package com.rocogz.syy.order.dto;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订单核销-> 用户券信息
 * @author zhangmin
 * @date 2020/4/28
 */
@Setter @Getter
public class OrderUserCouponDto {

    /**
     * 优惠券信息,基准券
     */
    private OrderCouponDto couponDto;

    /**
     * 用户券编码
     */
    private String userCouponCode;

    /**
     * 兑换码/核销码 例如：F42A1AB62BC81727
     */
    private String redeemCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 用户券 卡券面值
     */
    private BigDecimal faceValue;

    /**
     * 用户券状态：未生效、未使用、已使用、已过期、已冻结、已作废
     */
    private String status;

    /**
     * 用户券 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 使用失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 订单失效日期
     */
    private LocalDateTime orderInvalidDate;

    /**
     * 用户券总共能用次数
     */
    private Integer totalQuantity;

    /**
     * 已用次数
     */
    private Integer useQuantity;

    /**
     * 可用次数
     */
    private Integer availableQuantity;

    /**
     * 发放的服务券客户产品时：发放的目标客户
     * 会员编号
     */
    private String userCode;

    /**
     * 发放的服务券客户产品时：填写的发给目标客户名字
     * 目标客户名字
     */
    private String customerName;

    /**
     * 会员客户手机号
     */
    private String mobile;

    /**
     * 微信openid
     */
    private String openId;

    /**
     * 发放服务券客户产品时：页面或excel输入的 目标客户的保单号(根据发放主体 模版列)
     * 保单号
     */
    private String policyNo;

    /**
     * 发放服务券客户产品时：页面或excel输入的 目标客户的车牌号(根据发放主体 模版列)
     * 车牌号
     */
    private String licenseNo;

    /**
     * 发放服务券客户产品时：页面或excel输入的 目标客户的车架号(根据发放主体 模版列)
     * 车架号
     */
    private String vinNo;

    /**
     * 是否可用,当发放的用户服务券的供应链上游订单,更新为成功时，会更新用户券为可用
     * true=>表示可用,只有可用的用户券才能允许核销
     */
    private Boolean useable;

    /**
     * 是否已被客户领取
     */
    private Boolean received;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;


    /**
     * 业务类型(NORMAL:正常发券, SERVICE_TEST:业务验证)
     * 也是订单性质：订单的性质 = 使用的优惠券的性质
     */
    private String  serviceType;

}
