package com.rocogz.syy.order.dto.givenScheme;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description:保存或更新方案 </dd>
 * <dd>@date: 2023/08/15</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class BAgentGivenSchemeSaveReqDto {

    /**
     * 创建人的OpenId
     */
    private String createUserOpenId;

    /**
     * 方案编号
     */
    private String code;

    /**
     * 方案名称
     */
    private String name;

    /**
     * 预算范围 最小预算
     */
    private BigDecimal minBudget;

    /**
     * 预算范围 最大预算
     */
    private BigDecimal maxBudget;

    /**
     * 创建方案时的产品配置模式
     */
    private String goodsConfigModel;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体所属客户编号
     */
    private String customerCode;

    /**
     * 方案在那个小程序发的
     */
    private String miniAppid;

    /**
     * 账户费用类型
     */
    private String feeType;

    /**
     * 扣款个人账户
     */
    private String deductionPersonAccountNo;

    /**
     * 扣款个人账户所属的主体账户
     */
    private String deductionIssuingAccountNo;

    /**
     * 操作人用户名
     */
    private String operator;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 所在部门
     */
    private String operatorDept;

    /**
     * 所在岗位
     */
    private String operatorJob;

    /**
     * 创建人手机号
     */
    private String operatorMobile;

    /**
     * 产品列表
     */
    private List<BAgentGivenSchemeSaveReqItemDto> goodsList;

}
