package com.rocogz.syy.order.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 管理后台-> 商品订单 搜索 条件
 * @author ranxiangfu
 * @date 2020/8/18
 */
@Data
public class GoodsAdminSearchParamDto extends AdminBaseSearchDto {


    /**
     * 搜索页面来源于 浙商银行 平台产品订单
     */
    public static final String PAGE_PLATFORM_CUSTOMER_ORDER_LIST = "platform_customer_order_list";

    public GoodsAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.GOODS_ORDER);
    }


    private String addressee;
    //收货人手机 【模糊匹配】
    private String addresseeMobile;

    /**
     *  平台产品编号 或 供应商产品编号
     */
    private String goodsCode;

    // 产品简称 【模糊匹配】
    private String goodsName;

    //用户选择的供应商查询条件
    private String goodsSupplierCode;

    private String expressDeliveryName;
    //快递单号 【模糊匹配】
    private String expressDeliveryNumber;


    private String payWay;
    private String finishStartTime;
    private String finishEndTime;

    /**
     * 是否是查询：未填写快递信息, 未填写快递则必须满足如下条件
     * 1）订单的商品是【实物商品】product_type='GOODS'
     * 2）订单状态是【待收货】
     * 3）订单未填写快递信息：快递名称、快递单号
     */
    private Boolean notFillExpress;

    /**
     * 是否虚拟商品
     */
    private Boolean virtualGoods;

    private Boolean changeStatus2Delivered;

    //数据权限范围的供应商
    private List<String> supplierCodeList;

    private String bUserName;
    private String bUserMobile;
    private String bTeamCode;
    private String bOrgCode;
    private String bAgentCode;
    private String channel;
    private String planCode;
    private String planType;
    private String planModel;
    private String platformCode;
    private String sendStartTime;
    private String sendEndTime;

    /**
     * 积分兑换产品编码
     */
    private String pointExchangeProductCode;

    /**
     * 积分兑换产品名称
     */
    private String pointExchangeProductName;

    /**
     * 平台产品类型
     */
    private String productType;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * erp产品编码 【精准匹配】
     */
    private String erpProductCode;


    // ====== 下面的字段 是浙商银行 发放实物 用来查询的条件

    /**
     * 下单人姓名 【模糊匹配】
     */
    private String createUserFullName;

    /**
     * 下单人手机 【精准匹配】
     */
    private String createUserMobile;

    /**
     * 发放清单编号 【精准匹配】
     */
    private String businessCode;


    /**
     * 搜索来源menu，是否是来源于浙商银行的 平台产品订单 列表查询
     * 例如：platform_customer_order_list
     */
    private String fromPage="";


    //如果是导出，每次最多获取数据的条数量
    private Integer exportPerFetchSize;

    //如果是导出,ltOrderId不为null,则查询 主订单id < ltOrderId的订单数据
    private Integer ltOrderId;


    @JsonIgnore
    public String getCreateUserFullNameLike() {
        if (StringUtils.isBlank(createUserFullName)) {
            return null;
        }

        return "%"  + createUserFullName.trim() + "%";

    }


}
