package com.rocogz.syy.order.dto.goods;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;

/**
 * <dl>
 * <dd>Description: GoodsOrderReceiveDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/29 15:41</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Accessors(chain = true)
@Data
public class GoodsOrderReceiveDto {
    /**
     * 订单编号 [领取指定订单时必传]
     */
    private String orderCode;

    /**
     * 会员编号 [必传]
     */
    @NotEmpty
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    @NotEmpty
    private String mobile;

    /**
     * 会员openid [必传]
     */
    @NotEmpty
    private String openId;

    /**
     * 是否是实物发放订单 的领取
     */
    private Boolean grantGoodsOrderReceive = false;

    /**
     * 小程序miniAppid，实物发放订单 通过手机号 领取的时候，要限定C端是哪个小程序
     */
    private String miniAppid;
}
