package com.rocogz.syy.order.dto.trace;

import com.rocogz.syy.order.es.ThirdTraceLogEsDoc;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * thirdTrace搜索查询参数
 *
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
public class ThirdTraceSearchParamDto {

    private String coreCode;

    private String callApiPath;

    /**
     * 在bussParamJson字段上搜索的keyword
     * @see ThirdTraceLogEsDoc#bussParamJson
     */
    private String bussKeyword;

    private String sourcePlatform;
    private String targetPlatform;

    private LocalDateTime createStartTime;
    private LocalDateTime createEndTime;


    //pageSize,每页记录数
    private Integer limit = 20;

    //页码
    private Integer page = 1;

}
