package com.rocogz.syy.order.dto.withdrawals;

import com.rocogz.syy.order.entity.withdrawals.WithdrawalsRecord;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Objects;

/**
 * 最近10条 提现账户信息（只是提现到银行卡的）
 *
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
public class RecentWithdrawRecordAccountDto {

    /**
     * 身份证：真实姓名
     */
    private String idName;

    /**
     * 身份证号码
     */
    private String idCard;

    /**
     * 银行账户持卡人姓名
     */
    private String bankCardholderName;


    /**
     * 收款人手机号码,持卡人银行预留手机号
     */
    private String payeeMobile;

    /**
     * 银行名称:例如：招商银行
     */
    private String bankName;

    /**
     * 银行账户,即银行卡号
     */
    private String bankAccount;

    /**
     * 提现状态
     */
    private String withdrawStatus;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RecentWithdrawRecordAccountDto that = (RecentWithdrawRecordAccountDto) o;
        return Objects.equals(idName, that.idName) &&
                Objects.equals(idCard, that.idCard) &&
                Objects.equals(bankCardholderName, that.bankCardholderName) &&
                Objects.equals(payeeMobile, that.payeeMobile) &&
                Objects.equals(bankAccount, that.bankAccount) &&
                Objects.equals(withdrawStatus, that.withdrawStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(idName, idCard, bankCardholderName, payeeMobile, bankAccount, withdrawStatus);
    }


    public static RecentWithdrawRecordAccountDto of(WithdrawalsRecord record) {

        RecentWithdrawRecordAccountDto accountDto = new RecentWithdrawRecordAccountDto();
        accountDto.setIdName(record.getIdName())
                .setIdCard(record.getIdCard())
                .setBankCardholderName(record.getBankCardholderName())
                .setPayeeMobile(record.getPayeeMobile())
                .setBankName(record.getBankName())
                .setBankAccount(record.getBankAccount())
                .setWithdrawStatus(record.getWithdrawalsStatus());

        return accountDto;
    }
}
