package com.rocogz.syy.order.dto.withdrawals;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * 银行提现订单结算时 绑定上结算单号,就是在创建结算单时,与结算单建立上关联关系
 * @author zhangmin
 */
@Setter @Getter
@NoArgsConstructor
@AllArgsConstructor
public class WithdrawBindSettleBillParamDto {

    /**
     * 结算账户编号，【必须】 用来校验与提现订单中保存的结算账号是否一致
     */
    private String settleAcctCode;

    /**
     * 结算单编号 【必须】
     */
    private String billCode;


    /**
     * 结算明细单号关联关系 【必须】
     */
    private List<WithdrawSettleItem> settleItemList;

}
