package com.rocogz.syy.order.dto.withdrawals;

import lombok.Data;

/**
 * 管理后台-> 提现订单 搜索 条件
 *
 * @author ranxiangfu
 * @date 2020/8/4
 */
@Data
public class WithdrawalAdmSearchSettleParamDto {

    /**
     * 提现状态: PENDIND-待审批; PENDING_PROCESS-(已受理/待处理); REFUSE-(未受理/审核不通过);
     * PROCESSING-(转账中/处理中); SUCCESS-提现成功; FAIL-提现失败;
     */
    private String withdrawalsStatus;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     */
    private String withdrawalsWay;


    /**
     * 选择结算账户后，转让订单信息列表：默认展示当前查询到该结算账户关联的符合以下条件的全部转让订单：
     * 1）【提现状态】是【待处理】
     * 2）【收款方式】是【银行卡】
     * <p>
     * 结算账户编号
     */
    private String settleAcctCode;



    private Integer limit = 20;

    private Integer page = 1;

}
