package com.rocogz.syy.order.entity.givenScheme;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.GivenGiftSchemeConstant;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:礼品的赠送方案
 * 浙商里面引入的
 *
 * </dd>
 * <dd>@date: 2023/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName(value = "order_given_gift_scheme")
public class OrderGivenGiftScheme  extends IdEntity {
    /**
     * 方案编号
     */
    private String code;

    /**
     * 方案名称
     */
    private String name;

    /**
     * @see GivenGiftSchemeConstant.GivenGiftSchemeDictState#TYPE_CODE
     */
    private String status;

    /**
     * 预算范围 最小预算
     */
    private BigDecimal minBudget;

    /**
     * 预算范围 最大预算
     */
    private BigDecimal maxBudget;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 创建方案时的产品配置模式
     */
    private String goodsConfigModel;

    /**
     * 在哪个小程序创建的方案
     */
    private String miniAppid;

    /**
     * 账户费用类型
     */
    private String feeType;

    /**
     * 扣款个人账户
     */
    private String deductionPersonAccountNo;

    /**
     * 扣款个人账户所属的主体账户
     */
    private String deductionIssuingAccountNo;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建人手机号
     */
    private String createUserMobile;

    /**
     * 创建人姓名
     */
    private String createUserName;

    /**
     * 创建人所在部门
     */
    private String createUserDept;

    /**
     * 创建人job
     */
    private String createUserJob;

    /**
     * 创建人的OPENID
     */
    private String createUserOpenId;

    /**
     * 客户姓名/领取人姓名
     */
    private String receiverName;

    /**
     * 客户手机号/领取人手机
     */
    private String receiverMobile;

    /**
     * 分享时间给客户的时间
     */
    private LocalDateTime shareTime;

    /**
     * 客户确认时间
     */
    private LocalDateTime receiverConfirmTime;

    /**
     * 客户最近查看时间
     */
    private LocalDateTime receiverLastVisitTime;

    /**
     * 客户的OpenId,分享出去后
     * 第一次用户点击进来的openId.
     */
    private String receiverOpenId;

    /**
     * 提交申请的时间
     */
    private LocalDateTime applySubmitTime;

    /**
     * 清单发放成功时间
     */
    private LocalDateTime applySuccessTime;

    /**
     * 是否被逻辑删除 Y是删除，N是没有删除
     */
    private String deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 方案的item信息
     */
    @TableField(exist = false)
    private List<OrderGivenGiftSchemeGiftItem> itemList;


}
