package com.rocogz.syy.order.entity.givenScheme;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:方案的产品,里面是 </dd>
 * <dd>@date: 2023/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName(value = "order_given_gift_scheme_gift_item")
public class OrderGivenGiftSchemeGiftItem  extends IdEntity {
    /**
     * 方案编号
     */
    private String schemeCode;

    /**
     * 方案Item编号
     */
    private String schemeItemCode;

    /**
     * 合作产品编号
     */
    private String customerGoodsCode;

    /**
     * 客户产品名称/小程序显示名称
     */
    private String customerGoodsName;

    /**
     * 产品列表图
     */
    private String listView;

    /**
     * 客户产品的settlePrice
     * MerchantCustomerGoods#settlePrice
     */
    private BigDecimal settlePrice;

    /**
     * 客户产品的市场价
     */
    private BigDecimal marketPrice;

    /**
     * 已选择的 Y/N
     */
    private String selected;

    /**
     * 产品库类型:有这个标记就是产品库
     */
    private String proWhBelongType;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;



}
