package com.rocogz.syy.order.entity.givenScheme;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:礼品的赠送方案
 * 浙商里面引入的
 *
 * </dd>
 * <dd>@date: 2023/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName(value = "order_given_gift_scheme_log")
public class OrderGivenGiftSchemeLog extends IdEntity {

    /**
     * 方案编号
     */
    private String schemeCode;

    /**
     * 操作
     * @see OrderConstant.DictOrderAction
     */
    private String action;

    /**
     * 操作之前的状态
     * @see GivenGiftSchemeConstant.GivenGiftSchemeDictState#TYPE_CODE
     */
    private String beforeStatus;

    /**
     * 操作之后的状态
     * @see GivenGiftSchemeConstant.GivenGiftSchemeDictState#TYPE_CODE
     */
    private String afterStatus;

    /**
     * 操作人名字
     */
    private String actionUser;

    /**
     * 操作人
     */
    private String actionUserName;

    /**
     * 操作时间戳
     */
    private LocalDateTime createTime;

    /**
     *备注说明
     */
    private String remark;

}
