package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-商品订单收货地址
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order_delivery_address")
public class GoodsOrderDeliveryAddress extends IdEntity {

    private static final long serialVersionUID = 4421594597414149044L;
    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 关联的用户账户中地址Id,即选用的是用户帐户中的地址Id做为订单的收货地址id
     */
    private Integer refUserAddressId;

    /**
     * 收货人手机号
     */
    private String mobile;


    /**
     * 收货人
     */
    private String addressee;

    /**
     * 地址-省份
     */
    private String addressProvince;

    /**
     * 地址-城市
     */
    private String addressCity;

    /**
     * 地址-区/县
     */
    private String addressDistrict;

    /**
     * 地址-街道门牌号等信息
     */
    private String addressStreet;

    /**
     * 完整地址
     */
    private String fullAddress;

    /**
     * 标签名称
     */
    private String labelName;

    /**
     * 操作人
     */
    @TableField(exist = false)
    private String operateUser;


    /**
     * 填写收获地址时，填写的商品订单备注 用来更新商品订单的备注
     * @see com.rocogz.syy.order.entity.goods.GoodsOrder#remark
     */
    @TableField(exist = false)
    private String orderRemark;

}
