package com.rocogz.syy.order.entity.trace;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 *   第三方外部平台对接接口 调用跟踪
 * </p>
 *
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderThirdTrace extends BaseTrace {

    /**
     * 调用的源头的平台码
     */
    private String sourcePlatform;

    /**
     *调用的目标系统的平台码
     */
    private String targetPlatform;

    /**
     * 调用的接口：例如：/api/getToken
     */
    private String callApiPath;

    /**
     * 请求报文
     */
    private String reqBody;

    /**
     * 接口返回报文,如果发生异常，则保存异常堆栈日志
     */
    private String respBody;

    /**
     * 返回的解密后的业务实体 json
     */
    @TableField("resp_bean_json")
    private String respBussBeanJson;

    /**
     * 平均时间
     */
    @TableField(exist = false)
    private Double avgSpendMillis;

    /**
     * 请求次数
     */
    @TableField(exist = false)
    private Integer requestCount;



    @TableField(exist = false)
    private String docId;

}
