package com.rocogz.syy.order.entity.trace;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 历史 OrderThirdTrace 数据处理到Es的 计划进度
 *
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
public class OrderThirdTraceProcessEsPlan extends IdEntity {

    /**
     * 已处理到的数据id
     *
     * @see OrderThirdTrace#id
     */
    private Integer handledThirdTraceId;

    /**
     * 总记录数量
     */
    private Integer totalRecordNum;

    /**
     * 已处理数据条数
     */
    private Integer handledRecordNum;


    /**
     * 处理历时数据 总花费时间 （秒）
     */
    private Integer totalSpendSecond;

    /**
     * 处理进度：0.01  表示已处理 1%
     */
    private BigDecimal handledPercent;

    /**
     * 开始处理时间
     */
    private LocalDateTime handleStartTime;


    /**
     * 最后更新时间
     */
    private LocalDateTime lastUpdateTime;


    public void addHandledRecordNum(int increment) {
        if (handledRecordNum == null) {
            handledRecordNum = 0;
        }

        this.handledRecordNum = handledRecordNum + increment;
    }


    //本次循环处理数据,耗费的时间(秒)
    @TableField(exist = false)
    private transient Integer thisSpendSecord;
}
