package com.rocogz.syy.order.entity.trace;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * 历史 OrderThirdTrace数据处理到Es的 每日明细
 *
 * @author zhangmin
 */
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class OrderThirdTraceProcessEsPlanItem extends IdEntity {

    /**
     * 处理数据日期
     */
    private LocalDate handleDate;


    /**
     * 这1天已处理 记录数量
     */
    private Integer handleRecordNum;

}
