package com.rocogz.syy.order.entity.withdrawals;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-提现费率设置操作日志
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-09-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_fee_rate_config_log")
public class WithdrawalsFeeRateConfigLog extends IdEntity implements Serializable {

    private static final long serialVersionUID = -2079836555915048210L;

    /**
     *  (1） 如果是主体费率 修改状态：则code= issuingBodyCode
     * （2） 如果是个人费率 修改状态，则code= mobile （无主体编号时）
     * （3） 如果是主体下的 个人费率 修改状态,则code = mobile_issuingBodyCode （有主体编号时）
     */
    private String code;

    /**
     * 日志类型
     */
    private String type;

    /**
     * 日志内容
     */
    private String content;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


}
