package com.rocogz.syy.order.es;

import com.rocogz.syy.order.entity.trace.OrderThirdTrace;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 第三方调用日志 Es doc
 * @author zhangmin
 */
@Setter @Getter
public class ThirdTraceLogEsDoc {

    /**
     * 核心编号：例如订单号，支付号,核销码,用户券编号等,方便最快的定位问题
     */
    private String coreCode;

    /**
     * 调用的源头的平台码
     */
    private String sourcePlatform;

    /**
     *调用的目标系统的平台码
     */
    private String targetPlatform;

    /**
     * 调用的接口：例如：/api/getToken
     */
    private String callApiPath;

    /**
     * 业务请求参数json串
     */
    private String bussParamJson;

    /**
     * 返回消息
     */
    private String respMsg;

    /**
     * 返回状态码
     */
    private String respCode;

    /**
     * 接口耗时（毫秒数）
     */
    private Long spendMillis;

    /**
     * 接口调用开始时间
     */
    private LocalDateTime callStartTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 调用简短描述
     */
    private String description;

    /**
     * 请求报文
     */
    private String reqBody;

    /**
     * 接口返回报文,如果发生异常，则保存异常堆栈日志
     */
    private String respBody;



    public static ThirdTraceLogEsDoc of(OrderThirdTrace thirdTrace) {

        ThirdTraceLogEsDoc doc = new ThirdTraceLogEsDoc();

        doc.setBussParamJson(thirdTrace.getBussParamJson());
        doc.setCallApiPath(thirdTrace.getCallApiPath());
        doc.setCallStartTime(thirdTrace.getCallStartTime());
        doc.setCoreCode(thirdTrace.getCoreCode());
        doc.setCreateTime(thirdTrace.getCreateTime());
        doc.setReqBody(thirdTrace.getReqBody());
        doc.setRespBody(thirdTrace.getRespBody());
        doc.setRespCode(thirdTrace.getRespCode());
        doc.setRespMsg(thirdTrace.getRespMsg());
        doc.setSourcePlatform(thirdTrace.getSourcePlatform());
        doc.setTargetPlatform(thirdTrace.getTargetPlatform());
        doc.setSpendMillis(thirdTrace.getSpendMillis());
        doc.setDescription(thirdTrace.getDescription());

        return doc;
    }


    public OrderThirdTrace toThirdTrace() {

        OrderThirdTrace thirdTrace = new OrderThirdTrace();

        thirdTrace.setBussParamJson(getBussParamJson());
        thirdTrace.setCallApiPath(getCallApiPath());
        thirdTrace.setCallStartTime(getCallStartTime());
        thirdTrace.setCoreCode(getCoreCode());
        thirdTrace.setReqBody(getReqBody());
        thirdTrace.setCreateTime(getCreateTime());
        thirdTrace.setRespBody(getRespBody());
        thirdTrace.setSourcePlatform(getSourcePlatform());
        thirdTrace.setTargetPlatform(getTargetPlatform());
        thirdTrace.setSpendMillis(getSpendMillis());
        thirdTrace.setRespCode(getRespCode());
        thirdTrace.setRespMsg(getRespMsg());
        thirdTrace.setDescription(getDescription());

        return thirdTrace;
    }




}



