/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public final class ChineseHoliday {
    private static String specificHolidayUrl = "https://gameboylv.github.io/ChineseHoliday/data/%s.txt";
    private static String specificWorkdayUrl = "https://gameboylv.github.io/ChineseHoliday/data/%s_w.txt";
    private static Map<Integer, List<LocalDate>> holidayCache = new ConcurrentHashMap<Integer, List<LocalDate>>();

    private static List<LocalDate> holidayOfYear(int year) {
        ArrayList<LocalDate> holidayList = new ArrayList<LocalDate>();
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        int daysOfYear = firstDayOfYear.plusYears(1L).minusDays(1L).getDayOfYear();
        for (int i = 1; i <= daysOfYear; ++i) {
            LocalDate day = firstDayOfYear.withDayOfYear(i);
            if (day.getDayOfWeek() != DayOfWeek.SATURDAY && day.getDayOfWeek() != DayOfWeek.SUNDAY) continue;
            holidayList.add(day);
        }
        try {
            String[] specificHolidayArray;
            String holidayUrl = String.format(specificHolidayUrl, year);
            String specificHolidays = ChineseHoliday.getContentFromUrl(holidayUrl);
            for (String holiday : specificHolidayArray = specificHolidays.split("\\n")) {
                LocalDate holidayDate;
                if (StringUtils.isBlank((CharSequence)holiday) || (holiday = holiday.trim()).length() != 4 || holidayList.contains(holidayDate = LocalDate.of(year, Integer.parseInt(holiday.substring(0, 2)), Integer.parseInt(holiday.substring(2, 4))))) continue;
                holidayList.add(holidayDate);
            }
            String workDayUrl = String.format(specificWorkdayUrl, year);
            String specificWorkday = ChineseHoliday.getContentFromUrl(workDayUrl);
            for (String workDay : specificWorkday.split("\\n")) {
                LocalDate workDate;
                if (StringUtils.isBlank((CharSequence)workDay) || (workDay = workDay.trim()).length() != 4 || !holidayList.contains(workDate = LocalDate.of(year, Integer.parseInt(workDay.substring(0, 2)), Integer.parseInt(workDay.substring(2, 4))))) continue;
                holidayList.remove(workDate);
            }
            Collections.sort(holidayList);
        }
        catch (Exception ex) {
            holidayList = null;
        }
        return holidayList;
    }

    private static List<LocalDate> getHoliday(int year) {
        List<LocalDate> holidayListOfYear;
        if (!holidayCache.containsKey(year) && CollectionUtil.isNotEmpty(holidayListOfYear = ChineseHoliday.holidayOfYear(year))) {
            holidayCache.put(year, holidayListOfYear);
        }
        return holidayCache.get(year);
    }

    public static LocalDate getNextWorkingDate(LocalDate date) {
        LocalDate nextDate = date.plusDays(1L);
        while (!ChineseHoliday.isWorkingDay(nextDate)) {
            nextDate = nextDate.plusDays(1L);
        }
        return nextDate;
    }

    public static boolean isWorkingDay(LocalDate date) {
        List<LocalDate> holidayList = ChineseHoliday.getHoliday(date.getYear());
        if (CollectionUtil.isNotEmpty(holidayList)) {
            return !holidayList.contains(date);
        }
        boolean isWorkingDay = true;
        try {
            isWorkingDay = ChineseHoliday.isHolidayDayByDreace(date) == false;
        }
        catch (Exception ex) {
            isWorkingDay = ChineseHoliday.isWorkdayByLocal(date);
        }
        return isWorkingDay;
    }

    public static String getPredictReceiptTime(LocalDateTime createTime) {
        LocalDate createDate = createTime.toLocalDate();
        boolean workingDay = ChineseHoliday.isWorkingDay(createDate);
        LocalTime currentTime = createTime.toLocalTime();
        LocalTime sixtyTime = LocalTime.of(16, 0, 0);
        String predictReceiptTime = null;
        predictReceiptTime = workingDay && !currentTime.isAfter(sixtyTime) ? createDate.toString() + " 20:00" : ChineseHoliday.getNextWorkingDate(createDate).toString() + " 20:00";
        return predictReceiptTime;
    }

    private static Boolean isHolidayDayByDreace(LocalDate date) throws Exception {
        String url = "https://holiday.dreace.top/?date=" + date.toString();
        String dateJson = ChineseHoliday.getContentFromUrl(url);
        JSONObject jsonObj = JSONUtil.parseObj((String)dateJson);
        Boolean isHoliday = (Boolean)jsonObj.get((Object)"isHoliday");
        return Boolean.TRUE.equals(isHoliday);
    }

    private static boolean isWorkdayByLocal(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY;
    }

    private static String getContentFromUrl(String url) throws Exception {
        UrlResource urlRes = new UrlResource(new URL(url));
        String content = urlRes.readUtf8Str();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            content = content.trim();
        }
        return content;
    }
}

