package com.rocogz.syy.order.constant;

import java.math.BigDecimal;

/**
 * 常量
 *
 * @author：zhangmin
 * @since：2020/4/6
 */
public final class OrderConstant {

    public static final String APPLICATION_NAME = "order-base-service";

    /**
     * 对接平台 roco车服平台码,该平台码 来源于 基础服务系统中：basic_docking_platform表
     */
    public static final String DICT_PLATFORM_CODE_CAR_SERVICE = "SYY";

    /**
     *调用其他平台下单接口时, 最多尝试5次[不包括第一次]
     */
    public static final int MAX_RETRY_TIMES = 5;

    /**
     * 元和分的转换进制, 微信支付时使用的是分为单位.
     */
    public static final BigDecimal YUAN_FEE_EXCHANGE = new BigDecimal(100);

    /**
     * 提现订单审核中心回调地址
     */
    public static final String WITHDRAWALS_APPROVEMENT_CALL_BACK_URL = "/api/order/withdrawals-record/approvementCallBack";

    /** 公共的状态 是 */
    public final static String COMMON_STATUS_YES = "Y";

    /** 公共的状态 启用 */
    public final static String COMMON_STATUS_OPEN = "OPEN";

    /** 公共的状态 停用 */
    public final static String COMMON_STATUS_LOCK = "LOCK";

    // ======= 扫码核销前缀 =====>
    /** 使用服务券核销的的服务订单，扫码核销前缀 */
    public final static String COUPON_ORDER_WRITEOFF_CODE_PREFIX = "S";

    /** 使用积分兑换的的服务订单，扫码核销前缀 */
    public final static String COUPON_POINT_ORDER_WRITEOFF_CODE_PREFIX = "P";

    /** 预约订单,扫码核销前缀 */
    public final static String APPOINT_ORDER_WRITEOFF_CODE_PREFIX = "A";

    /** 车务平台中 订单核销码 前缀 */
    public final static String PICC_ORDER_WRITEOFF_CODE_PREFIX = "OD";

    /** 订单编码发号器编码 */
    public final static String SALE_ORDER_CODE_SERIAL_NO = "SALE_ORDER_CODE";

    /** 取消订单的redis锁前缀 */
    public final static String CANCEL_ORDER_LOCK_PREFIX = "CANCEL_ORDER:LOCK:";

    /**
     * 订单类型
     */
    public static class DictOrderType {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_TYPE";

        //=== 下面是字典值
        /**
         * 服务订单： 分2种类型的服务订单
         * （1）服务券核销的服务订单，走的是商户端核销下单流程，订单状态变化流程如下：
         *     商户端通过核销码核销 -> 核销下单成功（processing）->核销完成(pending_evaluate)-> 发布评价(evaluated)
         * （2）车主端 使用积分兑换服务
         *     车主端使用积分兑换下单成功（processing）->核销完成(pending_evaluate)-> 发布评价(evaluated)
         */
        public static final String COUPON_ORDER = "COUPON_ORDER";


        /**
         * 电子加油券订单(走的是加油卡券直接下单流程)
         * 订单状态变化流程如下：
         * 车主端下单（PENDING_PAY）-> 车主端调用支付成功后(PROCESSING) -> 充值完成后（FINISHED）
         */
        public static final String OIL_TICKET_ORDER = "OIL_TICKET_ORDER";

        /**
         * 预约订单
         * 订单状态变化流程如下：
         * 人保车务平台通过interface聚合项目下单(PENDING_USE) -> 核销完成（PENDING_EVALUATE）
         */
        public static final String APPOINTMENT_ORDER = "APPOINTMENT_ORDER";

        /**
         * 违章订单
         * 订单状态变化流程如下：
         * 车主端下单（PENDING_PAY）-> 车主端调用支付成功后(PROCESSING) -> 待鼎聚回调处理成功（FINISHED）
         */
        public static final String PECCANCY_ORDER = "PECCANCY_ORDER";

        /**
         * 提现订单
         * 提现订单状态变化流程如下，不是主订单信息的状态：
         * 车主端下单（PENDING）-> 后台管理审核通过(PENDING_PROCESS) -> 后台导出提现订单数据并操作为处理中（PROCESSING） -> 后台确定转账结果(SUCCESS/FAIL)
         */
        public static final String WITHDRAWALS_ORDER = "WITHDRAWALS_ORDER";

        /**
         * 商品订单
         * 商品订单状态变化流程如下
         * 车主端下单（PENDING_DELIVERY）-> 后台管理发货(DELIVERED) -> 车主端用户确认收货（FINISHED）
         */
        public static final String GOODS_ORDER = "GOODS_ORDER";

        /**
         * 年审订单
         * 年审订单状态变化流程如下
         * 车主端下单（PENDING_PAY）-> 车主端调用支付成功后(PROCESSING) -> 待鼎聚回调处理成功（FINISHED）
         */
        public static final String CAR_INSPECTION_ORDER= "CAR_INSPECTION_ORDER";
    }

    /**
     * 下订单渠道
     */
    public static class DictChannel {
        //字典类型编号
        public static final String TYPE_CODE = "CHANNEL";

        //=== 下面是字典值

        //车主端
        public static final String CAR_OWNER_WEAPP = "CAR_OWNER_WEAPP";

        //商户端
        public static final String MERCHANT_WEAPP = "MERCHANT_WEAPP";

        //管理后台
        public static final String ADMIN_DASHBOARD = "ADMIN_DASHBOARD";

        //接口调用
        public static final String API_CALL = "API_CALL";

        //ROCO特惠商城
        public static final String ROCO_MALL = "ROCO_MALL";

        //B端代理人小程序
        public static final String AGENT_WEAPP = "AGENT_WEAPP";

        // 供应链系统
        public static final String SCM = "SCM";
    }

    /**
     * 下单状态
     */
    public static class DictOrderStatus {
        //字典类型编号
        public static final String TYPE_CODE = "SALE_ORDER_STATUS";

        //=== 下面是字典值

        //待支付 （加油电子券订单刚创建时状态是待支付, 支付成功后是  "处理中"）
        public static final String PENDING_PAY = "PENDING_PAY";

        //处理中
        public static final String PROCESSING = "PROCESSING";

        //待使用,支付成功后就是待使用
        public static final String PENDING_USE = "PENDING_USE";

        //待发货(有发货步骤的订单，支付完成后就是待发货)
        public static final String PENDING_DELIVERY = "PENDING_DELIVERY";

        //待领取(转赠的商品订单，支付完成之后是待领取)
        public static final String PENDING_RECEIVE = "PENDING_RECEIVE";

        //待填写地址(有发货步骤的赠送订单，领取后是待填写地址)
        public static final String PENDING_SET_ADDRESS = "PENDING_SET_ADDRESS";

        //已发货(有发货步骤的订单，发货之后就是已发货)
        public static final String DELIVERED = "DELIVERED";

        //待评价,使用以后（核销成功后）就是待评价
        public static final String PENDING_EVALUATE = "PENDING_EVALUATE";

        //已评价
        public static final String EVALUATED = "EVALUATED";

        //已完成
        public static final String FINISHED = "FINISHED";

        //已取消
        public static final String CANCELED = "CANCELED";

        //已过期
        public static final String EXPIRED = "EXPIRED";

        /** 商户投保单 创建 */
        public static final String GIFT_CREATE = "GIFT_CREATE";
        /** 商户投保单 待确认 */
        public static final String GIFT_TO_BE_CONFIRMED = "GIFT_TO_BE_CONFIRMED";
        /** 商户投保单 待支付 */
        public static final String GIFT_TO_BE_PAID = "GIFT_TO_BE_PAID";
        /** 商户投保单 待赠送 */
        public static final String GIFT_TO_BE_SEND = "GIFT_TO_BE_SEND";
        /** 商户投保单 待领取 */
        public static final String GIFT_TO_BE_RECEIVE = "GIFT_TO_BE_RECEIVE";
        /** 商户投保单 已完成 */
        public static final String GIFT_COMPLETED = "GIFT_COMPLETED";
        /** 商户投保单 已失效 */
        public static final String GIFT_INVALID = "GIFT_INVALID";
        /** 商户投保单 已作废 */
        public static final String GIFT_TO_VOID = "GIFT_TO_VOID";
        /** 商户投保单 审核中 */
        public static final String GIFT_AUDIT = "GIFT_AUDIT";
        /** 商户投保单 拒绝 */
        public static final String GIFT_REFUSE = "GIFT_REFUSE";
    }

    /**
     * 订单支付方式================================
     */
    public static class DictPayWay {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_WAY";
        public static final String PLAN_TYPE = "GIFT_PLAN_TYPE";
        public static final String PLAN_MODEL = "GIFT_PLAN_MODEL";

        //=== 下面是字典值

        //电子券支付
        public static final String TICKET = "TICKET";

        //积分支付，由于以前叫"加油电子券支付",所以字典值就不改了,该支付方式的label改成积分支付
        public static final String OIL_TICKET = "OIL_TICKET";

        //代金券支付
        public static final String VOUCHER = "VOUCHER";

        //服务券支付
        public static final String COUPON = "COUPON";

        //外系统预约支付
        public static final String EXTERNAL_APPOINT = "EXTERNAL_APPOINT";
        //现金支付之 微信支付
        public static final String WEIXIN = "WEIXIN";
        //现金支付之 支付宝支付
        public static final String ALIPAY = "ALIPAY";
    }

    /**
     * 支付单的 支付状态
     */
    public static class DictPayStatus {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_STATUS";

        //=== 下面是字典值

        //未支付
        public static final String UN_PAY = "UNPAY";

        //部分支付
        public static final String PART_PAY = "PART_PAY";

        //支付完成
        public static final String PAIED = "PAIED";

    }


    /**
     * 订单退款状态
     */
    public static class DictRefundStatus {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_REFUND_STATUS";

        //=== 下面是字典值
        //退款中
        public static final String REFUNDING = "REFUNDING";

        //已退回
        public static final String REFUNDED = "REFUNDED";
    }

    /**
     * 订单核销方式
     */
    public static class DictWriteOffWay {

        //字典类型编号
        public static final String TYPE_CODE = "WRITE_OFF_WAY";

        //=== 下面是字典值

        // 商户端扫码
        public static final String SCAN_QR_CODE = "SCAN_QR_CODE";

        //商户端输入核销码
        public static final String INPUT_CODE = "INPUT_CODE";

        //后台手工核销
        public static final String ADMIN_MANUAL = "ADMIN_MANUAL";

    }

    /**
     * 订单 操作动作,用来记录操作流水
     */
    public static final class DictOrderAction {

        //字典类型编号
        public static final String TYPE_CODE = "ORDER_ACTION";

        //=== 下面是字典值

        //创建订单
        public static final String CREATE = "CREATE";

        //支付订单
        public static final String PAY = "PAY";

        //订单使用券
        public static final String USE_COUPON = "USE_COUPON";

        //核销订单
        public static final String WRITE_OFF = "WRITE_OFF";

        //取消订单
        public static final String CANCEL = "CANCEL";

        //结算
        public static final String SETTLE = "SETTLE";

        //逻辑删除
        public static final String DELETE = "DELETE";

        //充值完成【加油电子券订单】
        public static final String FINISH_DEPOSIT = "FINISH_DEPOSIT";



        // ===下面是 订单的评价 相关操作

        //发布评价
        public static final String PUBLISH_EVALUATION = "PUBLISH_EVALUATION";

        //设置精选
        public static final String SET_PERFECT = "SET_PERFECT";

        //取消精选
        public static final String CANCEL_PERFECT = "CANCEL_PERFECT";

        //隐藏评价
        public static final String HIDE_EVALUATION = "HIDE_EVALUATION";

        //显示评价
        public static final String SHOW_EVALUATION = "SHOW_EVALUATION";

        //删除评价
        public static final String DELETE_EVALUATION = "DELETE_EVALUATION";

        // === 提现订单 相关操作
        // 提现订单 -> 申请
        public static final String WITHDRAWALS_CREATE = "WITHDRAWALS_CREATE";
        // 提现订单 -> 支付
        public static final String WITHDRAWALS_PAY = "WITHDRAWALS_PAY";
        // 提现订单 -> 审批
        public static final String WITHDRAWALS_APPROVE = "WITHDRAWALS_APPROVE";
        // 提现订单 -> 处理
        public static final String WITHDRAWALS_PROCESS = "WITHDRAWALS_PROCESS";
        // 提现订单 -> 确认
        public static final String WITHDRAWALS_CONFIRM = "WITHDRAWALS_CONFIRM";
        // 提现订单 -> 修改收款信息
        public static final String WITHDRAWALS_MODIFY = "WITHDRAWALS_MODIFY";

        // === 商品订单 相关操作
        // 商品订单 -> 创建
        public static final String GOODS_ORDER_CREATE = "GOODS_ORDER_CREATE";
        // 商品订单 -> 取消
        public static final String GOODS_ORDER_CANCEL = "GOODS_ORDER_CANCEL";
        // 商品订单 -> 支付
        public static final String GOODS_ORDER_PAY = "GOODS_ORDER_PAY";
        // 商品订单 -> 赠送订单领取
        public static final String GOODS_ORDER_BESTOW_RECEIVE = "GOODS_ORDER_BESTOW_RECEIVE";
        // 商品订单 -> 赠送订单填写地址
        public static final String GOODS_ORDER_SET_ADDRESS = "GOODS_ORDER_SET_ADDRESS";
        // 商品订单 -> 发货
        public static final String GOODS_ORDER_SEND = "GOODS_ORDER_SEND";
        // 商品订单 -> 确认收货
        public static final String GOODS_ORDER_CONFIRM = "GOODS_ORDER_CONFIRM";
        // 商品订单 -> 实物发放订单领取
        public static final String GRANT_GOODS_ORDER_RECEIVE = "GRANT_GOODS_ORDER_RECEIVE";

        // == 商户投保单 相关操作
        // 商户投保单 创建
        public static final String GIFT_CREATE = "GIFT_CREATE";
        // 商户投保单 确认
        public static final String GIFT_CONFIRM = "GIFT_CONFIRM";
        // 商户投保单 支付
        public static final String GIFT_PAY = "GIFT_PAY";
        // 商户投保单 赠送
        public static final String GIFT_SEND = "GIFT_SEND";
        // 商户投保单 撤回
        public static final String GIFT_BACK = "GIFT_BACK";
        // 商户投保单 领取
        public static final String GIFT_RECEIVE = "GIFT_RECEIVE";
    }





    /**
     * 订单 结算状态
     */
    public static class DictSettleStatus {

        //字典类型编号
        public static final String TYPE_CODE = "SETTLEMENT_STATUS";

        //=== 下面是字典值

        // 未结算
        public static final String UN_SETTLE = "UN_SETTLE";

        //已结算
        public static final String SETTLED = "SETTLED";

    }

    /**
     * 车辆类型字典数据 在商户中心项目中已经有了，所以直接共用1份数据
     */
    public static class DictCarType {
        //字典类型编号
        public static final String TYPE_CODE = "AREA_SERVICE_CAR_TYPE";
    }


    /**
     * 订单评价 来源
     */
    public static class DictEvaluationOrigin {
        //字典类型编号
        public static final String TYPE_CODE = "EVALUATE_ORIGIN";

        //=== 下面是字典值
        // 自动评价
        public static final String AUTO = "AUTO";

        //会员评价
        public static final String USER = "USER";

    }

    /**
     * 提现方式
     */
    public static class DictWithdrawalsWay {
        /**
         * 提现到支付宝
         */
        public static final String ALIPAY = "ALIPAY";

        /**
         * 提现到银行账户
         */
        public static final String BANK = "BANK";
    }

    /**
     * 提现订单状态
     */
    public static class DictWithdrawalsStatus {
        /**
         * 提现记录状态
         */
        public static final String TYPE_CODE = "WITHDRAWALS_ORDER_STATUS";

        /**
         * 待审批(2021-05-20 删除审批流程 ranxiangfu)
         */
        public static final String PENDING = "PENDING";

        /**
         * 创建并支付后的提现订单记录状态就是 => 待处理
         */
        public static final String PENDING_PROCESS = "PENDING_PROCESS";

        /**
         * 审核不通过=> 未受理/审核不通过(2021-05-20 删除审批流程 ranxiangfu)
         */
        public static final String REFUSE = "REFUSE";

        /**
         * PENDING_PROCESS状态的 点击"开始处理"按钮 => 转账中/处理中
         */
        public static final String PROCESSING = "PROCESSING";

        /**
         * PROCESSING状态的提现记录,财务线下手工转账完成后，点击"提现成功"按钮 => 提现成功
         */
        public static final String SUCCESS = "SUCCESS";

        /**
         * PROCESSING状态的提现记录,财务人员如果不想转账,点击"提现失败"按钮  =>提现失败
         */
        public static final String FAIL = "FAIL";
    }

    /**
     * 提现费率设置
     */
    public static class DictWithdrawalsFeeRate {

        /**
         * 默认提现费率设置
         */
        public static final String DEFAULT_WITHDRAWALS_FEE_RATE_MOBILE = "*";

        /**
         * 提现费率字典类型编码
         */
        public static final String DICT_TYPE_CODE = "WITHDRAWALS_FEE_RATE";

        /**
         * 普通用户提现费率编码
         */
        public static final String NORMAL = "NORMAL";
    }

    /**
     * 提现订单每月兑换额度上限设置
     */
    public static class DictWithdrawalsUpperLimit {

        /**
         * 提现订单每月兑换额度上限设置字典类型编码
         */
        public static final String DICT_TYPE_CODE = "WITHDRAWALS_UPPER_LIMIT";

        /**
         * 普通用户每月兑换额度上限
         */
        public static final String NORMAL = "NORMAL";
    }

    public static class DictGoodsOrderPayWay {
        public static final String TYPE_CODE = "GOODS_ORDER_PAY_WAY";
        // 积分支付
        public static final String POINT = "POINT";
        // 现金支付
        public static final String CASH = "CASH";
        // 积分 + 现金混合支付
        public static final String POINT_AND_CASH = "POINT_AND_CASH";
        // 备付金支付
        public static final String DEPOSIT = "DEPOSIT";
        // 无需支付
        public static final String NO_NEED_PAY = "NO_NEED_PAY";
    }

    /**
     * 商品订单-下单类型
     */
    public static class DictGoodsOrderCreateType {
        public static final String TYPE_CODE = "GOODS_ORDER_CREATE_TYPE";
        // 投保礼商品赠送下单
        public static final String INSURANCE_GIFT_GOODS_BESTOW = "INSURANCE_GIFT_GOODS_BESTOW";
        // 投保礼商品下单
        public static final String INSURANCE_GIFT_GOODS_BUY = "INSURANCE_GIFT_GOODS_BUY";
        // 兑换商品下单
        public static final String EXCHANGE_GOODS_BUY = "EXCHANGE_GOODS_BUY";
        // 权益转赠-赠送商品下单
        public static final String GIVE_GOODS_BUY = "GIVE_GOODS_BUY";
        // 特惠专区-商品下单
        public static final String SPECIAL_ZONE_GOODS_BUY = "SPECIAL_ZONE_GOODS_BUY";
        // ROCO特惠商城-商品下单
        public static final String ROCO_MALL_GOODS_BUY = "ROCO_MALL_GOODS_BUY";
        // 权益线上领取活动-商品下单
        public static final String REO_GOODS_BUY = "REO_GOODS_BUY";
        // 分销或小程序发放实物-商品下单
        public static final String GRANT_GOODS = "GRANT_GOODS";
    }

    /**
     * 商品订单-积分回馈比例字典值设置
     */
    public static class DictGoodsOrderFeedbackRate {
        public static final String TYPE_CODE = "GOODS_ORDER_FEEDBACK_RATE";
        // 个人订单积分回馈比例
        public static final String SELF_FEEDBACK_RATE = "SELF_FEEDBACK_RATE";
        // 团员订单的积分回馈比例
        public static final String MEMBER_FEEDBACK_RATE = "MEMBER_FEEDBACK_RATE";
    }

    /**
     * 商品订单-积分回馈类型
     */
    public static class DictGoodsOrderFeedbackType {
        public static final String TYPE_CODE = "GOODS_ORDER_FEEDBACK_TYPE";
        // 个人订单积分回馈比例
        public static final String SELF = "SELF";
        // 团员(邀请的代理人)订单的积分回馈比例
        public static final String MEMBER = "MEMBER";
        // 注册
        public static final String REGISTERED = "REGISTERED";
        // 代理人认证
        public static final String AGENT_AUTH = "AGENT_AUTH";
    }

    public static class DictExpressDeliveryName {
        // 快递名称字典表
        public static final String TYPE_CODE = "EXPRESS_DELIVERY_NAME";
    }

    /**
     * 字典表类型
     */
    public class DictType {
        /** roco订单类型 */
        public final static String ROCO_TRADE_TYPE = "ROCO_TRADE_TYPE";
        /** 微信订单支付状态*/
        public final static String WX_TRADE_STATE="WX_TRADE_STATE";
        /** 微信支付交易类型*/
        public final static String WX_TRADE_TYPE="WX_TRADE_TYPE";
        /** 用户支付时使用的银行类型*/
        public final static String WX_BANK_TYPE="WX_BANK_TYPE";

        /** 微信退款状态 */
        public final static String WX_REFUND_STATUS = "WX_REFUND_STATUS";
        /** 微信订单退款发起来源*/
        public final static String WX_REFUND_REQUEST_SOURCE="WX_REFUND_REQUEST_SOURCE";
    }


    public static class  DictCarInspectionOrderType{

        public final static String CAR_INSPECTION_TYPE = "CAR_INSPECTION_TYPE";

        /**
         * 车辆年检
         */
        public final static String YEAR="YEAR";

        /**
         * 车辆免检
         */
        public final static String EXEMPTION="EXEMPTION";
    }

    public static class  DictCarInspectionYearMode{

        public final static String CAR_INSPECTION_TYPE = "CAR_INSPECTION_YEAR_MODE";

        /**
         * 自驾
         */
        public final static String SELF="self_diver_price";

        /**
         * 包车接送
         */
        public final static String THIRD="third_diver_price";

        /**
         * 修复包过
         */
        public final static String VIP="vip_price";
    }

    /**
     * 提现费率类型
     */
    public static class DictWithdrawalsFeeRateType {
        public final static String TYPE_CODE = "WITHDRAWALS_FEE_RATE_TYPE";

        /**
         * 默认
         */
        public final static String DEFAULT = "DEFAULT";

        /**
         * 发放主体
         */
        public final static String ISSUING_BODY = "ISSUING_BODY";

        /**
         * 个人
         */
        public final static String PERSON = "PERSON";
    }

}
