package com.rocogz.syy.order.dto.withdrawals;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: WithdrawalsSummaryResultDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/4 16:14</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
public class WithdrawalsSummaryResultDto {

    /**
     * 可用的虚拟货币总金额
     */
    private BigDecimal virtualCurrencyTotalAmount = new BigDecimal(0);

    /**
     * 正在提现中的虚拟货币总金额  sum(used_virtual_currency_amount) where withdrawals_status in ('PENDING', 'PENDING_PROCESS', 'PROCESSING')
     */
    private BigDecimal usingVirtualCurrencyTotalAmount = new BigDecimal(0);

    /**
     * 正在提现中的订单数量: withdrawals_status in ('PENDING', 'PENDING_PROCESS', 'PROCESSING') 的订单数量
     */
    private Integer processingWithdrawalsOrderCount = 0;

    /**
     * 累计提现成功到账总金额(元) =  sum(amount_to_the_account) where withdrawals_status = 'SUCCESS'
     */
    private BigDecimal withdrawalsTotalAmount = new BigDecimal(0);
}
