package com.rocogz.syy.order.entity.withdrawals;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-提现费率设置表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_fee_rate_config")
public class WithdrawalsFeeRateConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户手机号,默认提现费率时保存*
     */
    private String userMobile;

    /**
     * 提现费率
     */
    private BigDecimal feeRate;

    /**
     * 返点率,费率类型是主体 才有值
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal rebateRate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 公司
     */
    private String company;

    /**
     * 状态(OPEN:启用; LOCK:停用)
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 类型
     * @see OrderConstant.DictWithdrawalsFeeRateType
     */
    private String type;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

}
