/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.rabbitmq;

import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class RabbitMqService {
    @Autowired
    private RabbitTemplate template;

    public void sendMessage(String exchange, String routeKey, String message) {
        this.template.convertAndSend(exchange, routeKey, (Object)message);
    }

    public void sendMessage(String exchange, String routeKey, String message, RabbitTemplate.ConfirmCallback confirmCallback) {
        this.template.setConfirmCallback(confirmCallback);
        this.template.convertAndSend(exchange, routeKey, (Object)message);
    }

    private Message getMessage(String message) {
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        Message messages = new Message(message.getBytes(), messageProperties);
        return messages;
    }
}

