package com.rocogz.syy.rabbitmq;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * RabbitMQ 发送服务
 * @author：liangyongtong
 * @since：2020/4/19
 */
@Configuration
@Component
public class RabbitMqService {
    @Autowired
    private RabbitTemplate template;

    /**
     * 发送消息，不确认是否发送成功 (交换器，列表，绑定已处理)
     * @param exchange 交换器
     * @param routeKey 路由键
     * @param message 待发送消息
     */
    public void sendMessage(String exchange, String routeKey, String message) {
        template.convertAndSend(exchange, routeKey, message);
    }

    /**
     * 发送消息，带确认消息是否发送成功 (交换器，列表，绑定已处理) <br>
     * 需要配置 spring.rabbitmq.publisher-confirms=true
     * @param exchange 交换器
     * @param routeKey 路由键
     * @param message 消息对象
     * @param confirmCallback 消息发送结果
     */
    public void sendMessage(String exchange, String routeKey, String message, RabbitTemplate.ConfirmCallback confirmCallback) {
        template.setConfirmCallback(confirmCallback);
        template.convertAndSend(exchange, routeKey, message);
    }

    /**
     * 生成消息对象
     * @param message
     * @return
     */
    private Message getMessage(String message) {
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        Message messages = new Message(message.getBytes(),messageProperties);

        return messages;
    }

}
