/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.redis;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.util.NumberUtils;

@Configuration
@Component
public class RedisService {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private ValueOperations<String, String> valueOps;
    private ListOperations<String, String> listOps;
    private HashOperations<String, String, String> hashOps;
    private SetOperations<String, String> setOps;
    private ZSetOperations<String, String> zSetOps;

    @PostConstruct
    public void init() {
        this.valueOps = this.redisTemplate.opsForValue();
        this.listOps = this.redisTemplate.opsForList();
        this.hashOps = this.redisTemplate.opsForHash();
        this.setOps = this.redisTemplate.opsForSet();
        this.zSetOps = this.redisTemplate.opsForZSet();
    }

    public String get(String key) {
        return (String)this.valueOps.get((Object)key);
    }

    public Long getAsLong(String key) {
        String value = (String)this.valueOps.get((Object)key);
        return value == null ? null : (Long)NumberUtils.parseNumber((String)value, Long.class);
    }

    public void set(String key, String value) {
        this.valueOps.set((Object)key, (Object)value);
    }

    public Boolean setNx(String key, String value) {
        return this.valueOps.setIfAbsent((Object)key, (Object)value);
    }

    public void set(String key, String value, long timeout, TimeUnit timeUnit) {
        this.valueOps.set((Object)key, (Object)value, timeout, timeUnit);
    }

    public Boolean setIfAbsent(String key, String value) {
        return this.valueOps.setIfAbsent((Object)key, (Object)value);
    }

    public String getAndSet(String key, String value) {
        return (String)this.valueOps.getAndSet((Object)key, (Object)value);
    }

    public Long incr(String key) {
        return this.valueOps.increment((Object)key, 1L);
    }

    public Long incrBy(String key, long increment) {
        return this.valueOps.increment((Object)key, increment);
    }

    public void lpush(String key, String value) {
        this.listOps.leftPush((Object)key, (Object)value);
    }

    public String lpop(String key) {
        return (String)this.listOps.leftPop((Object)key);
    }

    public void lpushAll(String key, String ... values) {
        this.listOps.leftPushAll((Object)key, (Object[])values);
    }

    public void rpush(String key, String value) {
        this.listOps.rightPush((Object)key, (Object)value);
    }

    public String rpop(String key) {
        return (String)this.listOps.rightPop((Object)key);
    }

    public void rpushAll(String key, String ... values) {
        this.listOps.rightPushAll((Object)key, (Object[])values);
    }

    public void clearList(String key) {
        this.listOps.trim((Object)key, 1L, 0L);
    }

    public List<String> getListAllItems(String key) {
        return this.listOps.range((Object)key, 0L, -1L);
    }

    public Long llen(String key) {
        return this.listOps.size((Object)key);
    }

    public String hget(String key, String hashKey) {
        return (String)this.hashOps.get((Object)key, (Object)hashKey);
    }

    public Long hgetAsLong(String key, String hashKey) {
        String hashValue = (String)this.hashOps.get((Object)key, (Object)hashKey);
        return hashValue == null ? null : (Long)NumberUtils.parseNumber((String)hashValue, Long.class);
    }

    public void hset(String key, String hashKey, String hashValue) {
        this.hashOps.put((Object)key, (Object)hashKey, (Object)hashValue);
    }

    public void hsetAll(String key, Map<String, String> map) {
        this.hashOps.putAll((Object)key, map);
    }

    public Map<String, String> hgetAll(String key) {
        return this.hashOps.entries((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void deleteKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void deleteKeys(String ... keys) {
        this.deleteKeys(Arrays.asList(keys));
    }

    public void deleteKeys(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public void expire(String key, long timeout, TimeUnit timeUnit) {
        this.redisTemplate.expire((Object)key, timeout, timeUnit);
    }

    public void expireAt(String key, Date date) {
        this.redisTemplate.expireAt((Object)key, date);
    }

    public <T> T execute(RedisScript<T> redisScript, List<String> keys, Object ... args) {
        return (T)this.redisTemplate.execute(redisScript, keys, args);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        String str = (String)this.valueOps.get((Object)key);
        T t = this.stringToBean(str, clazz);
        return t;
    }

    private <T> T stringToBean(String str, Class<T> clazz) {
        if (str == null || str.length() <= 0 || clazz == null) {
            return null;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)Integer.valueOf(str);
        }
        if (clazz == String.class) {
            return (T)str;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)Long.valueOf(str);
        }
        return (T)JSON.parseObject((String)str, clazz);
    }
}

