/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.redis;

import com.rocogz.redis.RedisService;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributedLock
implements Lock {
    private static final String DEFAULT_LOCK_NAME = "redisDistributedLock";
    private static final String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private static RedisScript<Long> redisScript = new DefaultRedisScript("if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end", Long.class);
    private final long LOCK_DEFAULT_EXPIRE_TIME = 10000L;
    private final long RETRY_INTERVAL_MILLISECOND = 20L;
    private String lockName;
    private ThreadLocal<String> lockValueHolder = new ThreadLocal();
    private Thread executiveOwnerThread;
    @Autowired
    private RedisService redisService;

    public RedisDistributedLock() {
        this(DEFAULT_LOCK_NAME);
    }

    public RedisDistributedLock(String lockName) {
        this.lockName = lockName;
    }

    @Override
    public void lock() {
        while (!this.tryLock()) {
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean tryLock() {
        return this.tryAcquire(10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) {
        long base = System.currentTimeMillis();
        long elapsedTime = 0L;
        long waitMillis = unit.toMillis(waitTime);
        while (!this.tryAcquire(waitTime, unit)) {
            long delay = waitMillis - elapsedTime;
            if (delay <= 0L) {
                return false;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            elapsedTime = System.currentTimeMillis() - base;
        }
        return true;
    }

    private boolean tryAcquire(long ttl, TimeUnit unit) {
        String lockValue = UUID.randomUUID().toString();
        Thread currentThread = Thread.currentThread();
        if (this.redisService.setNx(this.lockName, lockValue).booleanValue()) {
            this.redisService.expire(this.lockName, ttl, unit);
            this.lockValueHolder.set(lockValue);
            this.setExecutiveOwnerThread(currentThread);
            return true;
        }
        return currentThread == this.executiveOwnerThread;
    }

    @Override
    public void unlock() {
        if (this.lockValueHolder.get() == null) {
            return;
        }
        Long deleteKeyNum = this.redisService.execute(redisScript, Arrays.asList(this.lockName), this.lockValueHolder.get());
        if (deleteKeyNum > 0L) {
            this.lockValueHolder.remove();
        }
    }

    @Override
    public Condition newCondition() {
        return null;
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
    }

    private void setExecutiveOwnerThread(Thread executiveOwnerThread) {
        this.executiveOwnerThread = executiveOwnerThread;
    }
}

