package com.rocogz.swagger.spring.boot.autoconfigure;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author zhangmin
 * @date 2020/1/16
 */
@Setter
@Getter
@ConfigurationProperties(prefix = "swagger")
public class SwaggerProperties {

    /**
     * 是否启动swagger,默认开启
     */
    private Boolean enabled;

    /**
     * 需要生成Api文档的,controller所在的Base包路径
     */
    private String basePackage;

    /**
     *公司版权信息,公司相关属性如果没有配置就使用默认公司属性值
     */
    private CompanyCopyRight company;

    @Setter
    @Getter
    public static class CompanyCopyRight {
        static final CompanyCopyRight DEFAULT_COMPANY = new CompanyCopyRight();
        static {
            DEFAULT_COMPANY.setName("广州大诚若谷信息技术有限公司");
            DEFAULT_COMPANY.setDescription("广州大诚系统项目");
            DEFAULT_COMPANY.setSiteUrl("http://www.rocoinfo.com");
            DEFAULT_COMPANY.setContactName("广州大诚技术部");
            DEFAULT_COMPANY.setContactEmail("admin_tech@rocogz.com");
            DEFAULT_COMPANY.setVersion("V1.0");
        }

        /**
         * 公司名称
         */
        private String name;

        /**
         * 公司官方网站
         */
        private String siteUrl;

        /**
         * 系统介绍
         */
        private String description;

        /**
         * 系统版本
         */
        private String version;

        /**
         *联系人名
         */
        private String contactName;

        /**
         * 联系人邮箱
         */
        private String contactEmail;

    }
}
