package com.rocogz.swagger.spring.boot.autoconfigure;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangmin
 * @date 2020/1/16
 */
@Setter
@Getter
@ConfigurationProperties(prefix = "swagger")
public class SwaggerProperties {

    /**
     * 是否启动swagger,默认开启
     */
    private Boolean enabled;

    /**
     * 需要生成Api文档的,controller所在的Base包路径
     */
    private String basePackage;


    /**
     * 如果接口需要token认证后才能访问（如果接口都是匿名访问，不要配置此参数）
     * 全局授权请求头参数,可以配置1个或多个请求头名称,用逗号分割 例如：Header("x-token","tkittqwedw")  Header("access-token","2081823d")
     */
    private String authHeaderNames;


    /**
     *  允许匿名访问的路径集合,支持Ant 路径Pattern, 多个路径用逗号分割（只针对全局配置为需授权时有效）
     *  例如：anonApiPathPatterns=/api/login/**,/api/sendSms
     */
    private String anonApiPathPatterns;

    /**
     *公司版权信息,公司相关属性如果没有配置就使用默认公司属性值
     */
    private CompanyCopyRight company;


    public List<String> getAuthHeaderNameList() {
        if(!StringUtils.hasText(authHeaderNames)) {
            return Collections.emptyList();
        }

        return Arrays.stream(StringUtils.trimArrayElements(authHeaderNames.split(","))).collect(Collectors.toList());
    }

    @Setter
    @Getter
    public static class CompanyCopyRight {
        static final CompanyCopyRight DEFAULT_COMPANY = new CompanyCopyRight();
        static {
            DEFAULT_COMPANY.setName("广州大诚若谷信息科技有限公司");
            DEFAULT_COMPANY.setDescription("广州大诚项目");
            DEFAULT_COMPANY.setSiteUrl("http://www.rocoinfo.com");
            DEFAULT_COMPANY.setContactName("广州大诚技术部");
            DEFAULT_COMPANY.setContactEmail("admin_tech@rocogz.com");
            DEFAULT_COMPANY.setVersion("V1.0");
        }

        /**
         * 公司名称
         */
        private String name;

        /**
         * 公司官方网站
         */
        private String siteUrl;

        /**
         * 系统介绍
         */
        private String description;

        /**
         * 系统版本
         */
        private String version;

        /**
         *联系人名
         */
        private String contactName;

        /**
         * 联系人邮箱
         */
        private String contactEmail;

    }
}
