package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.entity.Approvement;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 审核管理->审核申请
 * @author zhangmin
 * @date 2020/4/3
 */
@FeignClient(value = OperationConstant.APPLICATION_NAME,path = "/api/operation/approvement")
public interface ApprovementFeignClientService {

    /**
     * 后台列表查询
     * @param approveCode 审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved 是否已审核,默认未审核
     */
    @GetMapping
    public PageTable<Approvement> search(@RequestParam(name = "approveCode",required = false) String approveCode,
                                         @RequestParam(name = "bussinessCode",required = false) String bussinessCode,
                                         @RequestParam(name = "bussinessName",required = false) String bussinessName,
                                         @RequestParam(name = "bussinessType",required = false) String bussinessType,
                                         @RequestParam(name= "bussinessItem",required = false) String bussinessItem,
                                         @RequestParam(name = "approved",defaultValue = "false") Boolean approved,
                                         @RequestParam(name = "limit",defaultValue = "20") Integer limit,
                                         @RequestParam(name = "page",defaultValue = "1") Integer page);


    /**
     * 创建审批申请
     */
    @PostMapping("/create")
    public Response<String> create(@RequestBody Approvement approve);


    /**
     * 审批操作
     */
    @PostMapping("/approve")
    public Response<String> approve(@RequestBody Approvement approve);


}
