package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.entity.OperateBanner;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * <dl>
 * <dd>Description:  service</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020-04-09 下午 2:39</dd>
 * <dd>@author：yifenrui</dd>
 * </dl>
 */
@FeignClient(value = OperationConstant.APPLICATION_NAME,path = "/api/operation/banner")
public interface BannerFeignClientService {

    /**
     * banner列表
     * @param prefecturekeyword 分区搜索
     * @param status  状态
     * @param limit
     * @param page
     * @return
     */
    @GetMapping
    public PageTable<OperateBanner> findOperateBanner(
            @RequestParam(name = "prefecturekeyword",required = false) String prefecturekeyword,
            @RequestParam(name = "status",required = false) String status,
            @RequestParam(name = "limit",defaultValue = "20") int limit,
            @RequestParam(name = "page",defaultValue = "1") int page);

    /**
     * 新增和更新
     * @param operateBanner
     * @return
     */
    @PostMapping("/createOrUpdateBanner")
    public Response createOrUpdateBanner(@RequestBody OperateBanner operateBanner);



    /**
     * 根据id删除banner
     * @param id
     * @return
     */
    @DeleteMapping("/deleteBanner")
    public Response deleteBanner(@RequestParam(name = "code") String code);
}
