package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.dto.PrefectureDto;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

import static com.rocogz.syy.operation.constants.OperationConstant.TIME_ZONE;
import static com.rocogz.syy.operation.constants.OperationConstant.YYYY_MM_DD_HH_MM_SS;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2020-04-08
 */
@Data
@Accessors(chain = true)
@TableName("operate_banner")
public class OperateBanner extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * banner编码
     */
    private String code;

    /**
     * 标题
     */
    private String title;

    /**
     * 广告语
     */
    private String slogans;

    /**
     * 缩略图路径
     */
    private String photoPath;

    /**
     * 链接url
     */
    private String linkUrl;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 状态
     */
    private String status;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = YYYY_MM_DD_HH_MM_SS, timezone = TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人账号
     */
    private String updateUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = YYYY_MM_DD_HH_MM_SS, timezone = TIME_ZONE)
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 创建人账号
     */
    private String createUser;


    /**
     * 封装前端分区信息
     */
    @TableField(exist = false)
    private List<PrefectureDto> prefectureList;

    /**
     * 封装查询分区结果
     */
    @TableField(exist = false)
    private String prefectureStr;


}
