package com.rocogz.syy.operation.config.mp.methods;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.rocogz.syy.operation.annotation.UniqueField;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.springframework.core.annotation.AnnotatedElementUtils;

/**
 * @author zhangmin
 * @date 2020/3/30
 */
public abstract class AbstractCodeMethod extends AbstractMethod {


    protected ExtractedUniqueField extractedUniqueField(TableInfo tableInfo) {
        String uniqueColumnName  = "code";
        String uniquePropertyName = uniqueColumnName;
        TableFieldInfo uniqueField =  getUniqueField(tableInfo);
        if(uniqueField!=null) {
            uniquePropertyName = uniqueField.getProperty();
            uniqueColumnName = uniqueField.getColumn();
        }

        return new ExtractedUniqueField(uniquePropertyName,uniqueColumnName);
    }

    @Setter
    @Getter
    @AllArgsConstructor
    static class ExtractedUniqueField {
        private String propertyName;

        private String columnName;
    }


    private TableFieldInfo getUniqueField(TableInfo tableInfo) {
        TableFieldInfo uniqueField = null;
        for(TableFieldInfo field : tableInfo.getFieldList()) {
            UniqueField uniqueAnno = AnnotatedElementUtils.findMergedAnnotation(field.getField(),UniqueField.class);
            if(uniqueAnno!=null) {
                uniqueField = field;
                break;
            }
        }
        return uniqueField;
    }

}
