package com.rocogz.syy.operation.config.mp.methods;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;

/**
 * 通过编号获得实体对象
 * @author zhangmin
 */
public class GetByCode extends AbstractCodeMethod {

    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {

        ExtractedUniqueField uniqueField = extractedUniqueField(tableInfo);

        String sql = "select * from " + tableInfo.getTableName() + " where " + uniqueField.getColumnName() + "= #{" + uniqueField.getPropertyName()+ "}";
        /* 必须与mapper 接口方法名一致 */
        String method = "getByCode";
        SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, modelClass);
        return addSelectMappedStatementForTable(mapperClass, method, sqlSource, tableInfo);
    }
}
