package com.rocogz.syy.operation.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.basicserialno.service.SerialNoService;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.entity.Approvement;
import com.rocogz.syy.operation.enums.SerialNoTypeEnum;
import com.rocogz.syy.operation.service.ApprovementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.Objects;


/**
 * <p>
 * 审核管理->审核申请
 * </p>
 * @author zhangmin
 * @since 2020-04-03
 */
@RestController
@RequestMapping("/api/operation/approvement")
public class ApprovementRestController {

    @Autowired
    private ApprovementService approveService;
    @Autowired
    private SerialNoService serialNoService;


    /**
     * @param approveCode 审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved 是否已审核,默认未审核
     */
    @GetMapping
    public PageTable<Approvement> search(@RequestParam(required = false) String approveCode,
                                         @RequestParam(required = false) String bussinessCode,
                                         @RequestParam(required = false) String bussinessName,
                                         @RequestParam(required = false) String bussinessType,
                                         @RequestParam(required = false) String bussinessItem,
                                         @RequestParam(defaultValue = "false") Boolean approved,
                                         @RequestParam(defaultValue = "20") Integer limit,
                                         @RequestParam(defaultValue = "1") Integer page) {

        Page pageParam = new Page(page,limit);

        LambdaQueryWrapper<Approvement> whereCondition = Wrappers.lambdaQuery(Approvement.class);

        whereCondition.eq(StringUtils.isNotBlank(approveCode), Approvement::getCode,approveCode);
        whereCondition.eq(StringUtils.isNotBlank(bussinessCode),Approvement::getBusinessCode,bussinessCode);
        whereCondition.eq(StringUtils.isNotBlank(bussinessType),Approvement::getBusinessTypeCode,bussinessType);
        whereCondition.eq(StringUtils.isNotBlank(bussinessItem),Approvement::getBusinessItemCode,bussinessItem);
        whereCondition.eq(Approvement::getApproved,approved);
        whereCondition.like(StringUtils.isNotBlank(bussinessName),Approvement::getBusinessName,bussinessName);

        if(Boolean.TRUE.equals(approved)) {
            //已审核：按照审核时间倒序排列
            whereCondition.orderByDesc(Approvement::getApproveTime);
        }else {
            //未审核：按照提交时间倒序排列
            whereCondition.orderByDesc(Approvement::getId);
        }

        Page<Approvement> mpPage = approveService.page(pageParam, whereCondition);

        return PageTable.build(mpPage.getRecords(),(int)mpPage.getTotal());
    }


    @PostMapping("/create")
    public Response<String> create(@RequestBody Approvement approve) {
        String approveCode = serialNoService.generateCode(SerialNoTypeEnum.APPROVEMENT_CODE.name());
        approve.setCode(approveCode);
        approve.setApproved(Boolean.FALSE);
        approve.setPassed(Boolean.FALSE);

        this.approveService.save(approve);

        return Response.succeed("保存成功",approve.getCode());
    }



    @PostMapping("/approve")
    public Response<String> approve(@RequestBody Approvement approve) {

        String approveCode = approve.getCode();

        if(StringUtils.isBlank(approveCode)) {
            return Response.failure("审核单号code 不能为空");
        }

        if(Objects.isNull(approve.getPassed())) {
            return Response.failure("必须传入审核结果,passed=true或false");
        }

        Approvement approvement = approveService.getByCode(approveCode);
        if(approvement == null) {
            return Response.failure("要审核的单子不存在,approveCode：" + approveCode);
        }

        if(Boolean.TRUE.equals(approvement.getApproved())) {
            return Response.failure("该单子已审核,不能重复审核,approveCode：" + approveCode);
        }

        approvement.setApproved(Boolean.TRUE);
        approvement.setPassed(approve.getPassed());
        approvement.setApproveTime(LocalDateTime.now());
        approvement.setApproveUser(approve.getApproveUser());
        approvement.setApproveName(approve.getApproveName());

        LambdaQueryWrapper<Approvement> updateWhere = Wrappers.lambdaQuery(Approvement.class);
        updateWhere.eq(Approvement::getCode,approveCode);

        this.approveService.update(approvement,updateWhere);

        return Response.succeed("审核操作成功");
    }


}

