package com.rocogz.syy.operation.config.mp;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhangmin
 * mybatisPlus自动补全配置
 */
@Slf4j
@Component
public class MyMetaObjectHandler implements MetaObjectHandler {

    @Override
    public void insertFill(MetaObject metaObject) {
        String fieldName = "createTime";
        if (metaObject.hasSetter(fieldName)) {
            this.setFieldValByName(fieldName, LocalDateTime.now(), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        String updateFieldName = "updateTime";

        if (metaObject.hasSetter(updateFieldName)) {

            Object updateTime = this.getFieldValByName(updateFieldName, metaObject);
            //如果用户自己设置了更新时间，则以用户设置的为主
            if (Objects.isNull(updateTime)) {
                updateTime = LocalDateTime.now();
            }
            this.setFieldValByName(updateFieldName,updateTime,metaObject);
        }
    }
}