package com.rocogz.syy.operation.config.mp.methods;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;

/**
 * 删除编号删除实体对象
 * @author zhangmin
 */
public class DeleteByCode extends AbstractCodeMethod {

    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {

        ExtractedUniqueField uniqueField = extractedUniqueField(tableInfo);

        String sql = "delete from " + tableInfo.getTableName() + " where " + uniqueField.getColumnName() + "= #{" + uniqueField.getPropertyName()+ "}";
        /* 必须与mapper 接口方法名一致 */
        String method = "deleteByCode";
        SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, modelClass);
        return this.addDeleteMappedStatement(mapperClass, method, sqlSource);
    }



}
