package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.entity.*;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangmin
 * @date 2020/4/3
 */
public interface IOperationClientService {

    // =====  start 审核管理->审核申请   ========

    /**
     * 后台列表查询
     *
     * @param approveCode   审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved      是否已审核,默认未审核
     */
    @GetMapping("/api/operation/approvement")
    PageTable<Approvement> searchApproment(@RequestParam(name = "approveCode", required = false) String approveCode,
                                           @RequestParam(name = "bussinessCode", required = false) String bussinessCode,
                                           @RequestParam(name = "bussinessName", required = false) String bussinessName,
                                           @RequestParam(name = "bussinessType", required = false) String bussinessType,
                                           @RequestParam(name = "bussinessItem", required = false) String bussinessItem,
                                           @RequestParam(name = "approved", defaultValue = "false") Boolean approved,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 创建审批申请
     */
    @PostMapping("/api/operation/approvement/create")
    Response<String> createApprovement(@RequestBody Approvement approve);

    /**
     * 审批操作
     */
    @PostMapping("/api/operation/approvement/approve")
    Response<String> approveApprovement(@RequestBody Approvement approve);

    //  =========  end of  审核管理->审核申请   ===========

    //  =========  start of  banner 模块   ===========

    /**
     * banner列表
     *
     * @param prefecturekeyword 分区搜索
     * @param status            状态
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/banner")
    PageTable<OperateBanner> findOperateBanner(
            @RequestParam(name = "prefecturekeyword", required = false) String[] prefecturekeyword,
            @RequestParam(name = "status", required = false) String status,
            @RequestParam(name = "limit", defaultValue = "20") int limit,
            @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 新增和更新
     *
     * @param operateBanner
     * @return
     */
    @PostMapping("/api/operation/banner/createOrUpdateBanner")
    Response createOrUpdateBanner(@RequestBody OperateBanner operateBanner);

    /**
     * 根据code删除banner
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/banner/deleteBanner")
    Response deleteBanner(@RequestParam(name = "code") String code);

    /**
     * banner状态改变
     *
     * @param operateBanner banner
     * @return
     */
    @PostMapping("/api/operation/banner/status")
    Response switchBannerStatus(@RequestBody OperateBanner operateBanner);

    /**
     * 根据id查询banner信息
     *
     * @param id bannerid
     * @return
     */
    @GetMapping("/api/operation/banner/{id}")
    Response<OperateBanner> getOperateBannerById(@PathVariable("id") Integer id);

    /**
     * banner专区
     *
     * @param code bannerCode
     * @return
     */
    @PostMapping("/api/operation/banner/findPrefectureByCode")
    Response<List<OperateBannerPrefecture>> findPrefectureListByCode(@RequestParam(name = "code") String code);

    /**
     * banner管理-检测title是否重复
     *
     * @param code
     * @param title
     * @return
     */
    @PostMapping("/api/operation/banner/checkTitle")
    Response<List<OperateBanner>> checkTitle(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "title") String title);

    /**
     * 车主端-首页banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findIndexBanner")
    Response<List<OperateBanner>> findIndexBanner(@RequestParam(name = "code") String code);
    // =========  end of  banner 模块   ===========

    //  =========  start of  block 模块   ===========

    /**
     * 车主端-根据专区code查询版块
     *
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/block/findIndexOperateBlock")
    Response<List<OperateBlock>> findIndexOperateBlock(@RequestParam(name = "prefectureCode") String prefectureCode);

    /**
     * 版块管理-查询列表
     *
     * @param blockName
     * @param prefectureCode
     * @param status
     * @param areaCodes
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/block")
    PageTable<OperateBlock> searchBlock(@RequestParam(name = "blockName", required = false) String blockName,
                                        @RequestParam(name = "prefectureCode", required = false) String prefectureCode,
                                        @RequestParam(name = "status", required = false) String status,
                                        @RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                        @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                        @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 版块管理-更新版块的状态和排序
     *
     * @param operateBlock
     * @return
     */
    @PostMapping("/api/operation/block/statusOrSort")
    Response switchBlockStatusOrSort(@RequestBody OperateBlock operateBlock);

    /**
     * 版块管理-根据code删除版块
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/block/deleteBlock")
    Response deleteBlock(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateBlock
     * @return
     */
    @PostMapping("/api/operation/block/createOrUpdateBlock")
    Response createOrUpdateBlock(@RequestBody OperateBlock operateBlock);

    /**
     * 版块管理-根据id查询版块
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/block/{id}")
    Response<OperateBlock> getOperateBlockById(@PathVariable("id") Integer id);

    /**
     * 版块管理/车主端-根据版块code查询下面的商户
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/block/blockMerchantList")
    Response<List<OperateBlockMerchant>> blockMerchantList(@RequestParam(name = "code") String code);

    /**
     * 版块管理-根据版块code新增更新下面的商户
     *
     * @param code
     * @param merchenctCode
     * @return
     */
    @GetMapping("/api/operation/block/updateBlockMerchenct")
    Response updateBlockMerchenct(@RequestParam(name = "code", required = false) String code,
                                  @RequestParam(name = "merchenctCode", required = false) String[] merchenctCode);

    /**
     * 版块管理-根据版块code和商户code删除版块下的商户
     *
     * @param blockCode
     * @param merchantCode
     * @return
     */
    @PostMapping("/api/operation/block/removeMerchenct")
    Response removeMerchenct(@RequestParam(name = "blockCode") String blockCode, @RequestParam(name = "merchantCode") String merchantCode);

    /**
     * 版块管理-商户code更新位置值
     *
     * @param OperateBlockMerchant
     * @return
     */
    @PostMapping("/api/operation/block/merchenctSort")
    Response merchenctSort(@RequestBody OperateBlockMerchant OperateBlockMerchant);

    // =========  end of  block 模块   ===========

    //  =========  start of  栏目 模块   ===========

    @GetMapping("/api/operation/column")
    PageTable<OperateColumn> searchColumn(@RequestParam(name = "areaCodes",required = false) String[] areaCodes,
                                          @RequestParam(name = "name",required = false) String name,
                                          @RequestParam(name = "columnType",required = false) String columnType,
                                          @RequestParam(name = "status",required = false) String status,
                                          @RequestParam(name = "limit",defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page",defaultValue = "1") Integer page);

    /**
     * 栏目管理-更新栏目的状态和排序
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/statusOrSort")
    Response switchColumnStatusOrSort(@RequestBody OperateColumn operateColumn);


    /**
     * 栏目管理-根据code删除栏目
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/column/deleteColumn")
    Response deleteColumn(@RequestParam(name = "code") String code);



    /**
     * 新增和更新operateBlock
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/createOrUpdateColumn")
    Response createOrUpdateColumn(@RequestBody OperateColumn operateColumn);


    /**
     * 版块管理-根据id查询栏目
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/column/{id}")
    Response<OperateColumn> getOperateColumnById(@PathVariable("id") Integer id);


    /**
     * 车主端-根据专区code查询栏目
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/column/findIndexOperateColumn")
    Response<List<OperateColumn>> findIndexOperateColumn(@RequestParam(name = "prefectureCode") String prefectureCode);
    // =========  end of  栏目 模块   ===========


    //  =========  start of  systemMessage 模块   ===========

    /**
     * 系统信息列表
     *
     * @param title      信息标题(模糊匹配)
     * @param sendStatus 发布状态
     * @param page       页码
     * @param limit      每页条数
     * @return
     */
    @GetMapping("/api/operation/systemMessage")
    PageTable<SystemMessage> findSystemMessageList(@RequestParam(value = "title", required = false) String title,
                                                   @RequestParam(value = "sendStatus", required = false) String sendStatus,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 创建或更新系统信息
     *
     * @param systemMessage
     * @return
     */
    @PostMapping("/api/operation/systemMessage/saveOrUpdateSystemMessage")
    Response saveOrUpdateSystemMessage(@RequestBody SystemMessage systemMessage);

    /**
     * 修改发布状态
     *
     * @param systemMessage
     * @return
     */
    @PostMapping("/api/operation/systemMessage/changeSystemMessageSendStatus")
    Response changeSystemMessageSendStatus(@RequestBody SystemMessage systemMessage);

    /**
     * 复制系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/copySystemMessage/{id}")
    Response copySystemMessage(@PathVariable("id") Integer id);

    /**
     * 删除系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/deleteSystemMessageById/{id}")
    Response deleteSystemMessageById(@PathVariable("id") Integer id);

    /**
     * 根据id获取系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/getSystemMessageById/{id}")
    Response<SystemMessage> getSystemMessageById(@PathVariable("id") Integer id);

    /**
     * 消息列表页根据专区编码获取系统信息列表(分页)
     *
     * @param prefectureCode 专区编码
     * @param limit          每页数量
     * @param page           页码
     * @return
     */
    @GetMapping("/api/operation/systemMessage/pageSystemMessageListByPrefectureCode")
    PageTable<SystemMessage> pageSystemMessageListByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode,
                                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 首页根据专区编码获取系统信息列表(不分页)
     *
     * @param prefectureCode 专区编码
     * @return
     */
    @GetMapping("/api/operation/systemMessage/findSystemMessageListByPrefectureCode")
    Response<List<SystemMessage>> findSystemMessageListByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode);
    // =========  end of  systemMessage 模块   ===========
}
