package com.rocogz.syy.operation.constants;

/**
 * 运营中心基础服务，常量类
 * @author zhangmin
 * @date 2020/4/3
 */
public class OperationConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "operation-base-service";



    //需要审核的业务模块
    public static class ApproveBusinessType {

        //字典类型编号
        public static String TYPE_CODE = "approveBusiness";

        //商品模块
        public static String MERCHANT = "merchant";

        //订单模块
        public static String SALE_ORDER = "saleOrder";
    }

    //审批->商品模块->需要审核的项目
    public static class ApproveMerchantItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.MERCHANT;

        //商户模块下的 门店上架 审核项目编号
        public static String STORE_LIST = "STORE_LIST";
        public static String STORE_DELIST = "STORE_DELIST";
    }

    //审批->销售订单模块->需要审核的项目
    public static class ApproveSaleOrderItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.SALE_ORDER;

       //下面是订单模块的 审核项目编号

    }


    //栏目服务
    public static class ColumnService {

        //服务分类
        public static String SERVICE_TYPE = "SERVICE";
    }


}
