package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 运营模块->审核管理->审核申请表
 * </p>
 * @author zhangmin
 * @since 2020-04-03
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_approvement")
public class Approvement extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 审核申请单号
     */
    @UniqueField
    private String code;

    /**
     * 业务类型编号,数据来源于字典表
     */
    private String businessTypeCode;

    /**
     * 业务下的审核项目编号,如:门店审批(数据来源于字典表）
     */
    private String businessItemCode;

    /**
     * 业务对象编号,如：门店编号
     */
    private String businessCode;

    /**
     * 业务对象名称，如:门店名称
     */
    private String businessName;

    /**
     * 查看目标业务对象详情页跳转到url,该url不包括 商户端聚合服务的域名前缀
     * 例如：门店详情页：businessDetailUrl = merchant/store.html?storeCode=#{businessCode}
     */
    private String businessDetailUrl;

    /**
     * 是否审核
     */
    private Boolean approved;

    /**
     * 审批是否通过
     */
    private Boolean passed;


    /**
     * 提交人账号用户名
     */
    private String createUser;

    /**
     * 提交人名字
     */
    private String createName;

    /**
     * 提交时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 审批人用户名
     */
    private String approveUser;

    /**
     * 审批人名字
     */
    private String approveName;

    /**
     * 审批时间
     */
    private LocalDateTime approveTime;

}
