package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 系统信息
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "operate_system_message")
public class SystemMessage extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 信息编码
     */
    private String code;

    /**
     * 信息标题
     */
    private String title;

    /**
     * 信息内容
     */
    private String content;

    /**
     * 发布专区数量
     */
    private Integer publishPrefectureNumber;

    /**
     * 发布状态(分为隐藏hide 和 显示show)
     */
    private String sendStatus;

    /**
     * 专区编码列表
     */
    @TableField(exist = false)
    private List<String> prefectureCodeList;
}
