package com.rocogz.syy.operation.constants;

/**
 * 运营中心基础服务，常量类
 * @author zhangmin
 * @date 2020/4/3
 */
public class OperationConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "operation-base-service";

    public static class DictData {
        /** 注册推荐码类型 */
        public static final String REGISTER_IIUV_TYPE = "REGISTER_IIUV_TYPE";
        /** 推荐码商户类型 */
        public static final String REGISTER_IIUV_TYPE_MD = "MD";

        /** 通用的是 */
        public static final String COMMON_YES = "Y";
        /** 通用的否 */
        public static final String COMMON_NO = "N";

        /** 注册推荐码 小程序配置信息 */
        public static final String IIUV = "IIUV";
    }

    //审核的业务回调状态
    public static class ApproveCallBackStatus {

        //成功
        public static String CALLBACK_SUCCESS = "SUCCESS";

        //失败
        public static String CALLBACK_FAIL = "FAIL";
    }

    //需要审核的业务模块
    public static class ApproveBusinessType {

        //字典类型编号
        public static String TYPE_CODE = "approveBusiness";

        //商品模块
        public static String MERCHANT = "merchant";

        //订单模块
        public static String SALE_ORDER = "saleOrder";

        //订单模块
        public static String GOODS = "goods";
    }

    //审批->商品模块->需要审核的项目
    public static class ApproveMerchantItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.MERCHANT;

        //商户模块下的 门店上架 审核项目编号
        public static String STORE_LIST = "STORE_LIST";
        public static String STORE_DELIST = "STORE_DELIST";

        // 商户模块下的 商品上架  审核项目编号
        public static String GOODS_LIST = "GOODS_LIST";
    }

    //审批->销售订单模块->需要审核的项目
    public static class ApproveSaleOrderItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.SALE_ORDER;
        // 提现订单审核
        public static String WITHDRAWALS_APPROVE = "WITHDRAWALS_APPROVE";

       //下面是订单模块的 审核项目编号

    }


    //栏目服务
    public static class ColumnService {

        //服务分类
        public static String SERVICE_TYPE = "SERVICE";
    }


    /**
     * 二维码关联的 推荐码/跳转路径 标示类型
     */
    public static class DictOperateQrRelationType{

        /**
         * 推荐码标示
         */
        public final static String TYPE_IIUV="IIUV";

        /**
         * 跳转路径标示
         */
        public final static String TYPE_JUMP="JUMP";



    }


}
