package com.rocogz.syy.operation.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.operation.entity.OperateInsuranceCommission;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class OperateInsuranceCommissionPageDto extends OperateInsuranceCommission {

    /**
     * 商业险费率
     */
    private BigDecimal vciRate;

    /**
     * 交强险费率
     */
    private BigDecimal tciRate;

    /**
     * 开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    /**
     * 结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

}
