package com.rocogz.syy.operation.client;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.dto.*;
import com.rocogz.syy.operation.dto.qr.OperateQrScanHistoryDTO;
import com.rocogz.syy.operation.entity.*;
import com.rocogz.syy.operation.entity.attechment.OperateAttechment;
import com.rocogz.syy.operation.entity.opinion.OperateOpinion;
import com.rocogz.syy.operation.entity.qr.*;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author zhangmin
 * @date 2020/4/3
 */
public interface IOperationClientService {

    // =====  start 审核管理->审核申请   ========

    /**
     * 后台列表查询
     *
     * @param approveCode   审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved      是否已审核,默认未审核
     */
    @GetMapping("/api/operation/approvement")
    PageTable<Approvement> searchApproment(@RequestParam(name = "approveCode", required = false) String approveCode,
                                           @RequestParam(name = "bussinessCode", required = false) String bussinessCode,
                                           @RequestParam(name = "bussinessName", required = false) String bussinessName,
                                           @RequestParam(name = "bussinessType", required = false) String bussinessType,
                                           @RequestParam(name = "bussinessItem", required = false) String bussinessItem,
                                           @RequestParam(name = "approved", defaultValue = "false") Boolean approved,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 判断申请是否重复
     *
     * @param bussinessCode
     * @return
     */
    @GetMapping("/api/operation/approvement/findApprovement")
    Response<Approvement> findApprovement(@RequestParam(name = "bussinessCode", required = false) String bussinessCode);

    /**
     * 创建审批申请
     */
    @PostMapping("/api/operation/approvement/create")
    Response<String> createApprovement(@RequestBody Approvement approve);

    /**
     * 更新审批信息
     */
    @PostMapping("/api/operation/approvement/update")
    Response<String> updateApprovement(@RequestBody Approvement approve);

    /**
     * 审批操作
     */
    @PostMapping("/api/operation/approvement/approve")
    Response<String> approveApprovement(@RequestBody Approvement approve);

    @GetMapping("/api/operation/approvement/getBatchApprove")
    PageTable<Approvement> getBatchApprove(@RequestParam(name = "approveCodes", required = false) String[] approveCodes,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    //  =========  end of  审核管理->审核申请   ===========

    //  =========  start of  banner 模块   ===========

    /**
     * banner列表
     *
     * @param prefecturekeyword 分区搜索
     * @param status            状态
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/banner")
    PageTable<OperateBanner> findOperateBanner(
            @RequestParam(name = "prefecturekeyword", required = false) String[] prefecturekeyword,
            @RequestParam(name = "status", required = false) String status,
            @RequestParam(name = "showLocation", required = false) String showLocation,
            @RequestParam(name = "linkType", required = false) String linkType,
            @RequestParam(name = "systemEnd", required = false) String systemEnd,
            @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
            @RequestParam(name = "limit", defaultValue = "20") int limit,
            @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 新增和更新
     *
     * @param operateBanner
     * @return
     */
    @PostMapping("/api/operation/banner/createOrUpdateBanner")
    Response createOrUpdateBanner(@RequestBody OperateBanner operateBanner);

    /**
     * 根据code删除banner
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/banner/deleteBanner")
    Response deleteBanner(@RequestParam(name = "code") String code);

    /**
     * banner状态改变
     *
     * @param operateBanner banner
     * @return
     */
    @PostMapping("/api/operation/banner/status")
    Response switchBannerStatus(@RequestBody OperateBanner operateBanner);

    /**
     * 根据id查询banner信息
     *
     * @param id bannerid
     * @return
     */
    @GetMapping("/api/operation/banner/{id}")
    Response<OperateBanner> getOperateBannerById(@PathVariable("id") Integer id);

    /**
     * banner专区
     *
     * @param code bannerCode
     * @return
     */
    @PostMapping("/api/operation/banner/findPrefectureByCode")
    Response<List<OperateBannerPrefecture>> findPrefectureListByCode(@RequestParam(name = "code") String code);

    /**
     * banner管理-检测title是否重复
     *
     * @param code
     * @param title
     * @return
     */
    @PostMapping("/api/operation/banner/checkTitle")
    Response<List<OperateBanner>> checkTitle(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "title") String title);

    /**
     * 车主端-首页banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findIndexBanner")
    Response<List<OperateBanner>> findIndexBanner(@RequestParam(name = "code") String code, @RequestParam(name = "systemEnd") String systemEnd);

    /**
     * 车主端-去加油banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findOilingBanner")
    Response<List<OperateBanner>> findOilingBanner(@RequestParam(name = "code") String code, @RequestParam(name = "showLocation") String showLocation, @RequestParam(name = "systemEnd") String systemEnd);


    /**
     * 检测专区加名称唯一
     * @param id
     * @param pcodeList
     * @param name
     * @return
     */
    @GetMapping("/api/operation/banner/checkBannerUnique")
    Response<List<OperateBannerPrefecture>> checkBannerUnique(@RequestParam(name = "code",required = false) String code,@RequestParam(name = "pcodeList") List<String> pcodeList,@RequestParam(name = "name") String name);

    // =========  end of  banner 模块   ===========

    //  =========  start of  block 模块   ===========

    /**
     * 车主端-根据专区code查询版块
     *
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/block/findIndexOperateBlock")
    Response<List<OperateBlock>> findIndexOperateBlock(@RequestParam(name = "prefectureCode") String prefectureCode,
                                                       @RequestParam(name = "systemEnd") String systemEnd,
                                                       @RequestParam(name = "recommendType") String recommendType);

    /**
     * 版块管理-查询列表
     *
     * @param blockName
     * @param prefectureCode
     * @param status
     * @param areaCodes
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/block")
    PageTable<OperateBlock> searchBlock(@RequestParam(name = "blockName", required = false) String blockName,
                                        @RequestParam(name = "prefectureCode", required = false) String prefectureCode,
                                        @RequestParam(name = "status", required = false) String status,
                                        @RequestParam(name = "recommendType", required = false) String recommendType,
                                        @RequestParam(name = "systemEnd", required = false) String systemEnd,
                                        @RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                        @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
                                        @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                        @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 版块管理-更新版块的状态和排序
     *
     * @param operateBlock
     * @return
     */
    @PostMapping("/api/operation/block/statusOrSort")
    Response switchBlockStatusOrSort(@RequestBody OperateBlock operateBlock);

    /**
     * 版块管理-根据code删除版块
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/block/deleteBlock")
    Response deleteBlock(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateBlock
     * @return
     */
    @PostMapping("/api/operation/block/createOrUpdateBlock")
    Response createOrUpdateBlock(@RequestBody OperateBlock operateBlock);

    /**
     * 版块管理-根据id查询版块
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/block/{id}")
    Response<OperateBlock> getOperateBlockById(@PathVariable("id") Integer id);

    /**
     * 根据code查询版块信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/block/getOperateBannerByCode")
    Response<OperateBlock> getOperateBannerByCode(@RequestParam(name = "code") String code);

    /**
     * 版块管理/车主端-根据版块code查询下面的商户
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/block/blockMerchantList")
    Response<List<OperateBlockMerchant>> blockMerchantList(@RequestParam(name = "code") String code);

    /**
     * 版块管理-根据版块code新增更新下面的商户
     *
     * @param code
     * @param merchenctCode
     * @return
     */
    @GetMapping("/api/operation/block/updateBlockMerchenct")
    Response updateBlockMerchenct(@RequestParam(name = "code", required = false) String code,
                                  @RequestParam(name = "merchenctCode", required = false) String[] merchenctCode);

    /**
     * 版块管理-根据版块code和商户code删除版块下的商户
     *
     * @param blockCode
     * @param merchantCode
     * @return
     */
    @PostMapping("/api/operation/block/removeMerchenct")
    Response removeMerchenct(@RequestParam(name = "blockCode") String blockCode, @RequestParam(name = "merchantCode") String merchantCode);

    /**
     * 版块管理-商户code更新位置值
     *
     * @param OperateBlockMerchant
     * @return
     */
    @PostMapping("/api/operation/block/merchenctSort")
    Response merchenctSort(@RequestBody OperateBlockMerchant OperateBlockMerchant);

    /**
     * 检测专区加名称唯一
     * @param id
     * @param pcodeList
     * @param name
     * @return
     */
    @GetMapping("/api/operation/block/checkBlockUnique")
    Response<List<OperateBlock>> checkBlockUnique(@RequestParam(name = "id",required = false) Integer id,@RequestParam(name = "pcodeList") List<String> pcodeList,@RequestParam(name = "name") String name);


    // =========  end of  block 模块   ===========

    //  =========  start of  栏目 模块   ===========

    @GetMapping("/api/operation/column")
    PageTable<OperateColumn> searchColumn(@RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                          @RequestParam(name = "name", required = false) String name,
                                          @RequestParam(name = "columnType", required = false) String columnType,
                                          @RequestParam(name = "status", required = false) String status,
                                          @RequestParam(name = "systemEnd", required = false) String systemEnd,
                                          @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
                                          @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 栏目管理-更新栏目的状态和排序
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/statusOrSort")
    Response switchColumnStatusOrSort(@RequestBody OperateColumn operateColumn);

    /**
     * 栏目管理-根据code删除栏目
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/column/deleteColumn")
    Response deleteColumn(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/createOrUpdateColumn")
    Response createOrUpdateColumn(@RequestBody OperateColumn operateColumn);

    /**
     * 版块管理-根据id查询栏目
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/column/{id}")
    Response<OperateColumn> getOperateColumnById(@PathVariable("id") Integer id);

    /**
     * 车主端-根据专区code查询栏目
     *
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/column/findIndexOperateColumn")
    Response<List<OperateColumn>> findIndexOperateColumn(@RequestParam(name = "prefectureCode") String prefectureCode,@RequestParam(name = "systemEnd") String systemEnd);


    /**
     * 检测专区加名称唯一
     * @param id
     * @param prefectureCode
     * @param cloumnName
     * @return
     */
    @GetMapping("/api/operation/column/checkUnique")
    Response<List<OperateColumn>> checkUnique(@RequestParam(name = "id",required = false) Integer id,@RequestParam(name = "pcodeList") List<String> pcodeList,@RequestParam(name = "cloumnName") String cloumnName);

    // =========  end of  栏目 模块   ===========

    //  =========  start of  systemMessage 模块   ===========

    /**
     * 系统信息列表
     *
     * @param title      信息标题(模糊匹配)
     * @param sendStatus 发布状态
     * @param showPlace  展示位置
     * @param page       页码
     * @param limit      每页条数
     * @return
     */
    @GetMapping("/api/operation/systemMessage")
    PageTable<SystemMessage> findSystemMessageList(@RequestParam(value = "title", required = false) String title,
                                                   @RequestParam(value = "sendStatus", required = false) String sendStatus,
                                                   @RequestParam(value = "showPlace", required = false) String showPlace,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 创建或更新系统信息
     *
     * @param systemMessage
     * @return
     */
    @PostMapping("/api/operation/systemMessage/saveOrUpdateSystemMessage")
    Response saveOrUpdateSystemMessage(@RequestBody SystemMessage systemMessage);

    /**
     * 修改发布状态
     *
     * @param systemMessage
     * @return
     */
    @PostMapping("/api/operation/systemMessage/changeSystemMessageSendStatus")
    Response changeSystemMessageSendStatus(@RequestBody SystemMessage systemMessage);

    /**
     * 复制系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/copySystemMessage/{id}")
    Response copySystemMessage(@PathVariable("id") Integer id);

    /**
     * 删除系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/deleteSystemMessageById/{id}")
    Response deleteSystemMessageById(@PathVariable("id") Integer id);

    /**
     * 根据id获取系统信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/systemMessage/getSystemMessageById/{id}")
    Response<SystemMessage> getSystemMessageById(@PathVariable("id") Integer id);

    /**
     * 根据code获取系统信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/systemMessage/getSystemMessageByCode/{code}")
    Response<SystemMessage> getSystemMessageByCode(@PathVariable("code") String code);

    /**
     * 消息列表页根据专区编码获取系统信息列表(分页)
     *
     * @param prefectureCode 专区编码
     * @param showPlace      展示位置
     * @param limit          每页数量
     * @param page           页码
     * @return
     */
    @GetMapping("/api/operation/systemMessage/pageSystemMessageListByPrefectureCode")
    PageTable<SystemMessage> pageSystemMessageListByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode,
                                                                   @RequestParam("showPlace") String showPlace,
                                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 首页根据专区编码获取系统信息列表(不分页)
     *
     * @param prefectureCode 专区编码
     * @param showPlace      展示位置
     * @return
     */
    @GetMapping("/api/operation/systemMessage/findSystemMessageListByPrefectureCode")
    Response<List<SystemMessage>> findSystemMessageListByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode, @RequestParam("showPlace") String showPlace);
    // =========  end of  systemMessage 模块   ===========

    //  =========  start of message 模块   ===========

    /**
     * 根据参数查找消息模板列表
     *
     * @return
     */
    @GetMapping("/api/operation/msg/template/findMsgTemplateList")
    PageTable<OperateMsgTemplate> findMsgTemplateList(@RequestParam(value = "templateCode", required = false) String templateCode,
                                                      @RequestParam(value = "templateTitle", required = false) String templateTitle,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 保存或更新消息模板
     *
     * @return
     */
    @PostMapping("/api/operation/msg/template/saveOrUpdateMsgTemplate")
    Response saveOrUpdateMsgTemplate(@RequestBody OperateMsgTemplate operateMsgTemplate);

    /**
     * 根据templateCode 删除消息模板
     *
     * @param templateCode
     * @return
     */
    @GetMapping("/api/operation/msg/template/deleteMsgTemplateByTemplateCode/{templateCode}")
    Response deleteMsgTemplateByTemplateCode(@PathVariable("templateCode") String templateCode);

    /**
     * 根据templateCode 获取消息模板
     *
     * @param templateCode
     * @return
     */
    @GetMapping("/api/operation/msg/template/findMsgTemplateByTemplateCode/{templateCode}")
    Response<OperateMsgTemplate> findMsgTemplateByTemplateCode(@PathVariable("templateCode") String templateCode);

    /**
     * 根据模板消息给用户
     *
     * @return
     */
    @PutMapping("/api/operation/msg/template/sendTemplateMsgToUser")
    Response sendTemplateMsgToUser(@RequestBody OperateMsgTemplateDto msgTemplateDto);
    // =========  end of message 模块   ===========

    // =========  start of  推荐码管理 by liangyongtong   ===========

    /**
     * 查询列表信息
     *
     * @param iiuvCode 推荐码 精准匹配
     * @param iiuvName 推荐名称 模糊匹配
     * @param iiuvType 推荐类型
     * @param page     当前页
     * @param limit    每页条数
     * @return 查询列表
     */
    @GetMapping("api/operation/iiuv/queryPage")
    PageTable<OperateIiuv> operateIiuvPageTable(@RequestParam(value = "iiuvCode", required = false) String iiuvCode,
                                                @RequestParam(value = "iiuvName", required = false) String iiuvName,
                                                @RequestParam(value = "iiuvType", required = false) String iiuvType,
                                                @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 添加推荐码
     *
     * @param iiuv 推荐码数据
     * @return
     */
    @PostMapping("api/operation/iiuv/save")
    Response operateIiuvSave(@RequestBody OperateIiuv iiuv);

    /**
     * 添加推荐码
     *
     * @param iiuv 推荐码数据
     * @return
     */
    @PostMapping("/api/operation/iiuv/saveByStoreCode")
    Response<String> operateIiuvSaveByStoreCode(@RequestParam("storeCode") String storeCode,
                                                @RequestParam("storeName") String storeName,
                                                @RequestParam("type") String type,
                                                @RequestBody UserTimeEntity entity );

    /**
     * 根据推荐删除数据
     *
     * @param iiuvCode 推荐码
     * @return
     */
    @GetMapping("api/operation/iiuv/deleteByCode")
    Response operateIiuvDeleteByCode(@RequestParam(value = "iiuvCode") String iiuvCode);

    /**
     * 更新推荐二维码
     *
     * @param iiuv 推荐注册信息
     * @return
     */
    @PostMapping("api/operation/iiuv/genrate")
    Response operateIiuvGenrate(@RequestBody OperateIiuv iiuv);

    /**
     * 批量更新推荐二维码
     *
     * @param iiuvs 推荐注册信息
     * @return
     */
    @PostMapping("api/operation/iiuv/batchGenrate")
    Response operateIiuvBatchGenrate(@RequestBody List<OperateIiuv> iiuvs);

    /**
     * 通过编码数组查询推荐码信息
     *
     * @param iiuvCodes 推荐码数组
     * @return
     */
    @GetMapping("api/operation/iiuv/operateIiuvListByCodes")
    Response<List<OperateIiuv>> operateIiuvListByCodes(@RequestParam(value = "iiuvCodes") String[] iiuvCodes);

    /**
     * 获取推荐码详情
     *
     * @param iiuvCode 推荐码
     * @return
     */
    @GetMapping("api/operation/iiuv/detailByCode")
    Response<OperateIiuv> operateIiuvDetail(@RequestParam(value = "iiuvCode") String iiuvCode);
    // =========  end of  推荐码管理 by liangyongtong   ===========

    // =========  start of  小程序二维码生成配置 by liangyongtong   ===========

    /**
     * 根据类型获取小程序生成配置信息
     *
     * @param type 类型
     * @return
     */
    @GetMapping("api/operation/qrconfig/getByType")
    Response<OperateQrConfig> operateQrConfigByType(@RequestParam(value = "type") String type);

    /**
     * 通过编码获取对应的跳转配置
     *
     * @param code 编码
     * @return
     */
    @GetMapping("api/operation/qrparamer/getbycode")
    Response<OperateQrParameter> getOperateQrParameterByCode(@RequestParam(value = "code") String code);

    /**
     * 根据跳转路径编码删除数据
     *
     * @param code 跳转路径编码
     * @return
     */
    @GetMapping("api/operation/qrparamer/deleteByCode")
    Response deleteOperateQrParameterByCode(@RequestParam(value = "code") String code);

    /**
     * 查询列表信息
     *
     * @param code  跳转路径编码
     * @param name  跳转路径名称
     * @param type  跳转路径类型
     * @param page  当前页
     * @param limit 每页跳数
     * @return 查询列表
     */
    @GetMapping("api/operation/qrparamer/queryPage")
    PageTable<OperateQrParameter> operateQrParameterPageTable(@RequestParam(value = "code", required = false) String code,
                                                              @RequestParam(value = "name", required = false) String name,
                                                              @RequestParam(value = "type", required = false) String type,
                                                              @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                              @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 保存或更新saveOrUpdateUserQrParameter
     *
     * @param operateQrParameter
     * @return
     */
    @PostMapping("api/operation/qrparamer/saveOrUpdateOperateQrParameter")
    Response saveOrUpdateOperateQrParameter(@RequestBody OperateQrParameter operateQrParameter);

    // =========  end of  小程序二维码生成配置 by liangyongtong   ===========

    // =========  start of  二维码管理 by huhl   ===========

    @GetMapping("api/operation/qr/queryPage")
    PageTable<OperateQr> operateQrPageTable(@RequestParam(value = "qrCode", required = false) String qrCode,
                                            @RequestParam(value = "qrName", required = false) String qrName,
                                            @RequestParam(value = "relationType", required = false) String relationType,
                                            @RequestParam(value = "page", defaultValue = "1") Integer page,
                                            @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 删除二维码通过二维码编码
     *
     * @param code 二维码编码
     * @return
     */
    @GetMapping("api/operation/qr/deleteByCode")
    Response deleteOperateQrByCode(@RequestParam(value = "code") String code);

    /**
     * 获取二维码详情通过二维码编码
     *
     * @param code
     * @return
     */
    @GetMapping("api/operation/qr/detailByCode")
    Response<OperateQr> operateQrDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 保存二维码数据
     *
     * @param operateQr
     * @return
     */
    @PostMapping("api/operation/qr/saveOperateQr")
    Response saveOperateQr(@RequestBody OperateQr operateQr);

    /**
     * 保存二维码数据
     *
     * @param
     * @return
     */
    @PostMapping("/api/operation/qr/saveOperateQrByStoreCode")
    Response saveOperateQrByStoreCode(@RequestParam("relationCode") String relationCode, @RequestBody OperateQr qr);


    /**
     * 根据二维码编码查询集合
     *
     * @param qrCodes
     * @return
     */
    @GetMapping("api/operation/qr/operateQrListByCode")
    Response<List<OperateQr>> operateQrListByCode(@RequestParam(value = "qrCodes") String[] qrCodes);

    // =========  end of  二维码管理 by huhl   =============

    // ============= start of 返点费率设置 by luoyc==================

    /**
     * 保险公司返点费率列表
     *
     * @param limit
     * @param page
     * @param companyCode
     * @param companyName
     * @param status
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/pageInsuranceCommissionList")
    PageTable<OperateInsuranceCommissionPageDto> pageInsuranceCommissionList(
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page,
            @RequestParam(value = "companyCode", required = false) String companyCode,
            @RequestParam(value = "companyName", required = false) String companyName,
            @RequestParam(value = "status", required = false) String status);

    /**
     * 获取保险公司
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/gainInsuranceCommissionInfo/{code}")
    OperateInsuranceCommission gainInsuranceCommissionInfo(@PathVariable("code") String code);

    @PutMapping("/api/operation/insurance/commission/checkDate")
    Response checkDate(@RequestBody Map<String, Object> map);

    /**
     * 商户端公司费率列表
     *
     * @param companyName
     * @param vciRateOrderBy
     * @param tciRateOrderBy
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/listShopInsuranceCommissionAndSettingList")
    Response<List<OperateInsuranceCommissionShopPageDto>> listShopInsuranceCommissionAndSettingList(
            @RequestParam(value = "companyName", required = false) String companyName,
            @RequestParam(value = "vciRateOrderBy", required = false, defaultValue = "desc") String vciRateOrderBy,
            @RequestParam(value = "tciRateOrderBy", required = false, defaultValue = "desc") String tciRateOrderBy);

    /**
     * 根据公司code 和 费率code 获取信息
     *
     * @param companyCode
     * @param settingCode
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/gainShopInsuranceCommissionInfo/{companyCode}/{settingCode}")
    Response<OperateInsuranceCommissionDto> gainShopInsuranceCommissionInfoAndSetting(@PathVariable("companyCode") String companyCode,
                                                                                      @PathVariable("settingCode") String settingCode);

    /**
     * 启用/停用
     *
     * @param code
     * @param status
     * @return
     */
    @PutMapping("/api/operation/insurance/commission/updateStatus/{code}/{status}")
    Response updateInsuranceCommissionStatus(@PathVariable("code") String code, @PathVariable("status") String status, @RequestParam("updater")String updater);

    /**
     * 新增
     *
     * @param operateInsuranceCommissionDto
     * @return
     */
    @PostMapping("/api/operation/insurance/commission/save")
    Response saveInsuranceCommission(@RequestBody OperateInsuranceCommissionDto operateInsuranceCommissionDto);

    /**
     * 更新
     *
     * @param operateInsuranceCommissionDto
     * @return
     */
    @PostMapping("/api/operation/insurance/commission/update")
    Response updateInsuranceCommission(@RequestBody OperateInsuranceCommissionDto operateInsuranceCommissionDto);

    /**
     * 费率列表
     *
     * @param limit
     * @param page
     * @param oicCode
     * @param companyCode
     * @return
     */
    @GetMapping("/api/operation/insurance/rebate/rate/pageRebateRateSettingList")
    PageTable<OperateRebateRateSetting> pageRebateRateSettingList(
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page,
            @RequestParam(value = "oicCode", required = false) String oicCode,
            @RequestParam(value = "companyCode", required = false) String companyCode);

    /**
     * 修改费率设置
     *
     * @param operateRebateRateSetting
     * @return
     */
    @Deprecated
    @PostMapping("/api/operation/insurance/rebate/rate/update")
    Response updateRebateRateSetting(@RequestBody OperateRebateRateSetting operateRebateRateSetting);

    /**
     * 修改状态 未生效->生效->作废、未生效->作废
     *
     * @param code
     * @param status
     * @return
     */
    @Deprecated
    @PutMapping("/api/operation/insurance/rebate/rate/updateStatus/{code}/{status}")
    Response updateRebateRateSettingStatus(@PathVariable("code") String code, @PathVariable("status") String status, @RequestParam("updater") String updater);

    /**
     * 过期费率设置任务
     *
     * @return
     */
    @GetMapping("/api/operation/insurance/rebate/rate/scheduleExpireRebateRateSetting")
    Response<String> scheduleExpireRebateRateSetting();

    /**
     * 操作日志列表
     *
     * @param limit
     * @param page
     * @param oicCode
     * @param companyCode
     * @return
     */
    @GetMapping("/api/operation/insurance/commission/log/pageInsuranceCommissionLogList")
    PageTable<OperateInsuranceCommissionLog> pageInsuranceCommissionLogList(
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page,
            @RequestParam(value = "oicCode", required = false) String oicCode,
            @RequestParam(value = "companyCode", required = false) String companyCode);
    // ============= end of 返点费率设置 by luoyc==================

    @PostMapping("/api/operation/iiuv/gainQrCodesByStoreCodes")
    public Response<Map<String, MerchantStoreQrDto>> gainQrCodesByStoreCodes(@RequestBody List<String> storeCodes);

    @GetMapping("/api/operation/qr/gainQrUrlByStoreCode/{storeCode}")
    public Response<OperateQr> gainQrUrlByStoreCode(@PathVariable("storeCode") String storeCode);

    // ============= start of 意见反馈 by yinshihao==================

    /**
     * 保存意见反馈
     *
     * @return
     */
    @PostMapping("/api/operation/opinion/saveOpinion")
    Response saveOpinion(@RequestBody OperateOpinion opinion);

    /**
     * 根据用户编码和openid获取该用户的意见列表
     *
     * @param userCode
     * @param openid
     * @return
     */
    @GetMapping("/api/operation/opinion/findOpinionsByUserCodeAndOpenid")
    Response<List<OperateOpinion>> findOpinionsByUserCodeAndOpenid(@RequestParam("userCode") String userCode,
                                                                   @RequestParam(value = "openid", required = false) String openid);

    /**
     * 根据意见编码获取意见信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/opinion/getOpinionByCode")
    Response getOpinionByCode(@RequestParam("code") String code);

    /**
     * 后台分页查询用户意见列表
     *
     * @param code
     * @param userCode
     * @param openid
     * @param phone
     * @param source
     * @param opinionType
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/opinion/findOpinionsPageTable")
    PageTable<OperateOpinion> findOpinionsPageTable(@RequestParam(value = "code",required = false) String code,
                                                    @RequestParam(value = "userCode",required = false) String userCode,
                                                    @RequestParam(value = "openid",required = false) String openid,
                                                    @RequestParam(value = "phone",required = false) String phone,
                                                    @RequestParam(value = "source",required = false) String source,
                                                    @RequestParam(value = "opinionType",required = false) String opinionType,
                                                    @RequestParam(value = "createTimeStart", required = false) String createTimeStart,
                                                    @RequestParam(value = "createTimeEnd", required = false) String createTimeEnd,
                                                    @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                    @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 后台导出用户意见列表
     *
     * @param code
     * @param userCode
     * @param openid
     * @param phone
     * @param source
     * @param opinionType
     * @param createTimeStart
     * @param createTimeEnd
     * @return
     */
    @GetMapping("/api/operation/opinion/findOpinionsList")
    Response<List<OperateOpinion>> findOpinionsList(@RequestParam(value = "code",required = false) String code,
                                                    @RequestParam(value = "userCode",required = false) String userCode,
                                                    @RequestParam(value = "openid",required = false) String openid,
                                                    @RequestParam(value = "phone",required = false) String phone,
                                                    @RequestParam(value = "source",required = false) String source,
                                                    @RequestParam(value = "opinionType",required = false) String opinionType,
                                                    @RequestParam(value = "createTimeStart", required = false) String createTimeStart,
                                                    @RequestParam(value = "createTimeEnd", required = false) String createTimeEnd);

    // ============= end of 意见反馈 by yinshihao==================

    // ============= start of 返点费率设置 by luoyc==================

    /**
     * 保存二维码扫码历史记录
     *
     * @param operateQrScanHistoryDTO
     * @return
     */
    @PostMapping("/api/operation/qr/history/saveQrHistory")
    Response saveQrHistory(@RequestBody OperateQrScanHistoryDTO operateQrScanHistoryDTO);

    @GetMapping("/api/operation/qr/history/operateQrHistoryPageTable")
    PageTable<OperateQrScanHistory> operateQrHistoryPageTable(@RequestParam(value = "qrCode") String qrCode,
                                                              @RequestParam(value = "userMobile", required = false) String userMobile,
                                                              @RequestParam(value = "wxOpenid", required = false) String wxOpenid,
                                                              @RequestParam(value = "scanTimeStart", required = false) LocalDateTime scanTimeStart,
                                                              @RequestParam(value = "scanTimeEnd", required = false) LocalDateTime scanTimeEnd,
                                                              @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                              @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    // ============= end of 返点费率设置 by luoyc==================

    // ============= start of 代理人二维码 by luoyc==================

    /**
     * 获取代理人推荐码、二维码
     * @param code 当前用户code
     * @return OperateIiuvQrDTO
     */
    @GetMapping("/api/operation/iiuv/getUserAgentIiuvCodeAndQrCode")
    Response<OperateIiuvQrDTO> getUserAgentIiuvCodeAndQrCode(@RequestParam(value = "code") String code);

    /**
     * 获取/创建代理人推荐码
     *
     * @param code 当前用户code
     * @return OperateIiuv
     */
    @GetMapping("/api/operation/iiuv/gainOrCreateUserAgentIiuvCode")
    Response<OperateIiuv> gainOrCreateUserAgentIiuvCode(@RequestParam(value = "code") String code, @RequestParam(value = "iiuvName") String iiuvName);
    // ============= end of 代理人二维码 by luoyc==================

}
