package com.rocogz.syy.operation.entity.qr;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.dto.qr.OperateQrRelationTypeDto;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * <dl>
 * <dd>Description:二维码 </dd>
 * <dd>@date: 2020/07/15</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName("operate_qr")
public class OperateQr extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     *二维码编码
     */
    private String code;

    /**
     *二维码名称
     */
    private String name;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 二维码图片路径
     */
    private String qrUrl;

    /**
     * 二维码关联类型，推荐码/扫码跳转路径，保存数据时使用
     */
    @TableField(exist = false)
    private List<OperateQrRelationType> relationTypes = new ArrayList<>();

    /**
     * 详情DTO
     */
    @TableField(exist = false)
    private List<OperateQrRelationTypeDto> relationTypesDetailsDto=new ArrayList<>();


    /**
     * 列表页面,行上关联的类型
     */
    @TableField(exist = false)
    private List<String> strRelationTypes = new ArrayList<>();


}
