package com.rocogz.syy.operation.entity.filter;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 运营服务-筛选条件组日志表
 * </p>
 *
 * @author luoyc
 * @since 2021-01-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("operate_filter_log")
public class OperateFilterLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 油站筛选页code
     */
    private String filterPageCode;

    /**
     * 操作项
     */
    private String operate;

    /**
     * 变更信息
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer size = 10;


}
