package com.rocogz.syy.operation.entity.message;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.entity.OperateMsgTemplate;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 发放主体短信配置 </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/8/2 16:01</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@TableName("operate_issuing_body_message")
public class OperateIssuingBodyMessage extends UserTimeEntity {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 短信模板编号 {@link OperateMsgTemplate#getTemplateCode()}
     */
    private String msgTemplateCode;

    /**
     * 是否是默认配置
     */
    private Boolean isDefault;

    /**
     * 短信模板内容
     */
    @TableField(exist = false)
    private String messageContent;
}
