package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.dto.PrefectureDto;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 首页商户推荐-版块表
 * </p>
 *
 * @author yifenrui
 * @since 2020-04-11
 */
@Data
@Accessors(chain = true)
@TableName("operate_block")
public class OperateBlock extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 版块名称
     */
    private String blockName;

    /**
     * 版块说明
     */
    private String blockDescription;

    /**
     * 位置值
     */
    private Integer sort;

    /**
     * 状态
     */
    private String status;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人账号
     */
    private String updateUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人账号
     */
    private String createUser;

    /**
     * 专区code
     */
    private String prefectureCode;

    /**
     * 推荐类型
     */
    private String recommendType;

    /**
     * 副标题
     */
    private String blockSubTitle;

    /**
     * 专区name
     */
    private String prefectureName;

    /**
     * 系统端
     */
    private String systemEnd;

    /**
     * 封装前端商户信息
     */
    @TableField(exist = false)
    private List<OperateBlockMerchant> operateBlockMerchantList;

    /**
     * 封装前端分区信息
     */
    @TableField(exist = false)
    private List<PrefectureDto> prefectureList;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniName;

    /**
     * 小程序是否可显示代理人端
     */
    @TableField(exist = false)
    private String appBizStatus;

}
