package com.rocogz.syy.operation.entity.quotapply;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 发放主体额度申请 申请人账号设置
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateQuotaConfigAccount extends IdEntity {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 额度申请人专用账号:申请人用户名 reference basic_system_admin_user.username
     */
    private String applierUser;

    /**
     * 额度申请人名字
     */
    private String applierName;

    /**
     * 员工编号
     */
    private String empCode;

    /**
     * 员工所在部门
     */
    private String deptName;


}
