package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 保险佣点表
 *
 * @author luoyc
 * @since 2020-08-26
 */
@Data
@Accessors(chain = true)
@TableName("operate_insurance_commission")
public class OperateInsuranceCommission extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码（表唯一字段，相当于主键功效）
     */
    private String code;

    /**
     * 保险公司代码（唯一）
     */
    private String companyCode;

    /**
     * 保险公司名称（唯一）
     */
    private String companyName;

    /**
     * 状态（启用 NORMAL、停用 LOCK）
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
}
