package com.rocogz.syy.operation.entity.quotapply;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 客户权益管理-> 额度申请审批记录
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter @Getter
@Accessors(chain = true)
public class OperateQuotaApplyApproveRecord extends IdEntity {

    /**
     * 申请单编码
     */
    private String applyCode;

    /**
     * 审批结果, 通过或不通过
     * @see OperationConstant.DictApproveResult
     */
    private String result;

    /**
     * 审批的节点编号
     */
    private String approveNodeCode;

    /**
     * 审批类型: 审核 或 审批
     */
    private QuotaApproveNodeTypeEnum approveNodeType;

    /**
     * 审批节点名称
     */
    private  String approveNodeName;

    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审批人手机号
     */
    private String approverMobile;

    /**
     * 批注
     */
    private String remark;

    /**
     * 审批时间，也就是创建时间
     */
    private LocalDateTime approveTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
