package com.rocogz.syy.operation.entity.quotapply;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 额度申请当前的审批流节点, 运行时流程实例节点
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
public class OperateQuotaApplyRuntimeNode extends BaseQuotaNode {

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 流程版本
     */
    private Integer version;

    /**
     * 下一个审批节点
     *
     * @see OperateQuotaDictNode#code
     */
    private String nextNodeCode;

    /**
     * 该节点是否审批完了，即是否走完了该流程
     */
    private Boolean approved;



}
